/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.pizza;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.bakeries.block.pizza.CustomPizzaBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomPizzaBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SLICE = IntegerProperty.m_61631_((String)"slice", (int)0, (int)3);
    protected static final VoxelShape BOX = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);

    public CustomPizzaBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SLICE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return BOX;
    }

    public int getSlice() {
        return 4;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        return this.eat(pState, pLevel, pPos, (LivingEntity)pPlayer, pHand, pHit);
    }

    public InteractionResult eat(BlockState pState, Level pLevel, BlockPos pPos, LivingEntity livingEntity, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        Player player = null;
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
        }
        if ((blockEntity = pLevel.m_7702_(pPos)) instanceof CustomPizzaBlockEntity) {
            CustomPizzaBlockEntity pizza = (CustomPizzaBlockEntity)blockEntity;
            int nutrition = pizza.getNutrition();
            float saturationMod = pizza.getSaturationMod();
            if (player != null) {
                player.m_36324_().m_38707_(nutrition, saturationMod);
            }
            this.addEffects(pizza, livingEntity);
            pLevel.m_142346_((Entity)livingEntity, GameEvent.f_157806_, pPos);
            int slice = (Integer)pState.m_61143_((Property)SLICE);
            if (slice < this.getSlice() - 1) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)SLICE, (Comparable)Integer.valueOf(slice + 1)), 3);
            } else {
                pLevel.m_7471_(pPos, false);
            }
            pLevel.m_5594_(null, pPos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void addEffects(CustomPizzaBlockEntity pizza, LivingEntity livingEntity) {
        List<List<Pair<MobEffectInstance, Float>>> effects = pizza.getEffects(livingEntity);
        for (List<Pair<MobEffectInstance, Float>> pairs : effects) {
            for (Pair<MobEffectInstance, Float> mobEffectInstanceFloatPair : pairs) {
                livingEntity.m_7292_((MobEffectInstance)mobEffectInstanceFloatPair.getFirst());
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CustomPizzaBlockEntity(pPos, pState);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, SLICE});
    }
}

