/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.pizza;

import com.mojang.datafixers.util.Pair;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CustomPizzaBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(4){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    };
    private int nutrition;
    private float saturationMod;

    public CustomPizzaBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.CUSTOM_PIZZA_ENTITY.get(), pPos, pBlockState);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturationMod() {
        return this.saturationMod;
    }

    public void setNutrition(int nutrition) {
        this.nutrition = nutrition;
    }

    public void setSaturationMod(float saturationMod) {
        this.saturationMod = saturationMod;
    }

    public void setFoodProperties(int nutrition, float saturationMod) {
        this.nutrition = nutrition;
        this.saturationMod = saturationMod;
    }

    public List<List<Pair<MobEffectInstance, Float>>> getEffects(LivingEntity livingEntity) {
        ArrayList<List<Pair<MobEffectInstance, Float>>> lists = new ArrayList<List<Pair<MobEffectInstance, Float>>>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_() || !stackInSlot.m_41720_().m_41472_()) continue;
            List effects = Objects.requireNonNull(new ItemStack((ItemLike)stackInSlot.m_41720_()).getFoodProperties(livingEntity)).m_38749_();
            lists.add(effects);
        }
        return lists;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.nutrition = tag.m_128451_("Nutrition");
        this.saturationMod = tag.m_128457_("SaturationMod");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("Nutrition", this.nutrition);
        tag.m_128350_("SaturationMod", this.saturationMod);
    }
}

