/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.pizza;

import com.renyigesai.bakeries.block.pizza.PizzaFlatbreadBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.recipe.PizzaRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PizzaFlatbreadBlockEntity
extends BlockEntity {
    private ItemStackHandler inventory = new ItemStackHandler(4){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };
    private ItemStackHandler cheeses = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }
    };

    public PizzaFlatbreadBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.PIZZA_FLATBREAD_ENTITY.get(), pPos, pBlockState);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getCheeses() {
        return this.cheeses;
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getItem(int pSlot) {
        return this.inventory.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.inventory.extractItem(pSlot, pAmount, false);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return null;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.inventory.setStackInSlot(pSlot, pStack);
    }

    public void drops(PizzaFlatbreadBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots() + 1);
        for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = blockEntity.inventory.getStackInSlot(i);
            if (stackInSlot.hasCraftingRemainingItem()) continue;
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        inventory.m_6836_(4, this.cheeses.getStackInSlot(0));
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public void removeItems() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.cheeses.setStackInSlot(0, ItemStack.f_41583_);
        this.updateBlock();
    }

    public boolean isSynthesis() {
        if (this.f_58857_ != null) {
            return !this.cheeses.getStackInSlot(0).m_41619_() && (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)PizzaFlatbreadBlock.SAUCE) != false;
        }
        return false;
    }

    public boolean addItem(ItemStack stack, Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            if (!stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("bakeries:not_pizza_ingredients")))) {
                if (stack.hasCraftingRemainingItem()) {
                    ItemUtil.givePlayerItem(player, stack.getCraftingRemainingItem());
                }
                this.inventory.setStackInSlot(i, stack);
                this.updateBlock();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean startSynthesis() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.isSynthesis() && this.isEmpty()) {
            this.removeItems();
            this.f_58857_.m_46597_(this.f_58858_, ((Block)BakeriesBlocks.RAW_PIZZA.get()).m_49966_());
            return true;
        }
        Optional<PizzaRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            PizzaRecipe pizzaRecipe = currentRecipe.get();
            ItemStack resultItem = pizzaRecipe.m_8043_(null);
            this.removeItems();
            Item item = resultItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                this.f_58857_.m_7731_(this.f_58858_, blockItem.m_40614_().m_49966_(), 3);
            } else {
                this.f_58857_.m_7471_(this.f_58858_, false);
                ItemUtil.spawnItemEntity(this.f_58857_, resultItem, this.f_58858_);
            }
            return true;
        }
        return false;
    }

    public ItemStack getSynthesisItem() {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        if (this.isSynthesis() && this.isEmpty()) {
            return new ItemStack((ItemLike)BakeriesItems.RAW_PIZZA.get());
        }
        Optional<PizzaRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            PizzaRecipe pizzaRecipe = currentRecipe.get();
            return pizzaRecipe.m_8043_(null);
        }
        ItemStack pizza = new ItemStack((ItemLike)BakeriesItems.RAW_CUSTOM_PIZZA.get(), 1);
        CompoundTag compoundTag = new CompoundTag();
        ItemStackHandler handler = new ItemStackHandler(4);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            handler.setStackInSlot(i, this.inventory.getStackInSlot(i));
        }
        compoundTag.m_128365_("Inventory", (Tag)handler.serializeNBT());
        pizza.m_41751_(compoundTag);
        return pizza;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("Cheeses", (Tag)this.cheeses.serializeNBT());
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("Cheeses")) {
            this.cheeses.deserializeNBT(tag.m_128469_("Cheeses"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("Cheese", (Tag)this.cheeses.serializeNBT());
    }

    public Optional<PizzaRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i < 4; ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PizzaRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public void updateBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        PizzaFlatbreadBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)state);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }

    public Vec2[] getVec2() {
        float size = 0.15f;
        Vec2[] vec2s = new Vec2[]{new Vec2(0.5f, 0.5f + size), new Vec2(0.5f, 0.5f - size), new Vec2(0.5f + size, 0.5f), new Vec2(0.5f - size, 0.5f)};
        return vec2s;
    }

    public Vec2[] getCheeseVec2() {
        float size = 0.2f;
        Vec2[] vec2s = new Vec2[]{new Vec2(0.46875f, 0.46875f), new Vec2(0.5f + size, 0.5f + size), new Vec2(0.5f - size, 0.5f + size), new Vec2(0.5f + size, 0.5f - size), new Vec2(0.5f - size, 0.5f - size)};
        return vec2s;
    }
}

