/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.stone_kiln;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.item.CustomPizzaItem;
import com.renyigesai.bakeries.recipe.StoneKilnRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class StoneKilnBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    };
    private int cookingTime = 0;
    private int maxCookingTime = 0;
    private int stageCookingTime = 0;
    private int maxStageCookingTime = 0;
    public int turnOver = 0;
    public boolean isTurnOver;
    private int maxTurnOver;
    private float size = 0.0f;
    private int nextStage = 0;
    public float progress;
    public float progressOld;
    private AnimationStatus animationStatus = AnimationStatus.STOP;

    public StoneKilnBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.STONE_KILN_ENTITY.get(), pPos, pBlockState);
    }

    public void setAnimationStatus(AnimationStatus animationStatus) {
        this.animationStatus = animationStatus;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public ItemStack getItem(int pSlot) {
        return this.inventory.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.inventory.extractItem(pSlot, pAmount, false);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.inventory.setStackInSlot(pSlot, pStack);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public float getSize() {
        return this.size;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getMaxCookingTime() {
        return this.maxCookingTime;
    }

    public int getStageCookingTime() {
        return this.stageCookingTime;
    }

    public int getMaxStageCookingTime() {
        return this.maxStageCookingTime;
    }

    public int getTurnOver() {
        return this.turnOver;
    }

    public int getMaxTurnOver() {
        return this.maxTurnOver;
    }

    public int getNextStage() {
        return this.nextStage;
    }

    public float getProgress(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isTurnOver() {
        return this.isTurnOver;
    }

    public boolean addItem(ItemStack stack) {
        if (this.isEmpty()) {
            this.inventory.setStackInSlot(0, stack);
            this.size = 0.0f;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            return true;
        }
        return false;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128385_("CookingTime", new int[]{this.cookingTime, this.maxCookingTime});
        tag.m_128385_("StageCookingTime", new int[]{this.stageCookingTime, this.maxStageCookingTime});
        tag.m_128385_("TurnOver", new int[]{this.turnOver, this.maxTurnOver});
        tag.m_128379_("IsTurnOver", this.isTurnOver);
        tag.m_128350_("Size", this.size);
        return tag;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        int[] cookingTimes = tag.m_128465_("CookingTime");
        this.cookingTime = cookingTimes[0];
        this.maxCookingTime = cookingTimes[1];
        int[] stageCookingTimes = tag.m_128465_("StageCookingTime");
        this.stageCookingTime = stageCookingTimes[0];
        this.maxStageCookingTime = stageCookingTimes[1];
        int[] turnOvers = tag.m_128465_("TurnOver");
        this.turnOver = turnOvers[0];
        this.maxTurnOver = turnOvers[1];
        this.isTurnOver = tag.m_128471_("IsTurnOver");
        this.size = tag.m_128457_("Size");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128385_("CookingTime", new int[]{this.cookingTime, this.maxCookingTime});
        tag.m_128385_("StageCookingTime", new int[]{this.stageCookingTime, this.maxStageCookingTime});
        tag.m_128385_("TurnOver", new int[]{this.turnOver, this.maxTurnOver});
        tag.m_128379_("IsTurnOver", this.isTurnOver);
        tag.m_128350_("Size", this.size);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoneKilnBlockEntity blockEntity) {
        if (!blockEntity.isEmpty()) {
            blockEntity.cookingTick();
            blockEntity.m_6596_();
            if (!level.f_46443_) {
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            if (pType == 0) {
                this.animationStatus = AnimationStatus.TURN_OVER;
                StoneKilnBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, StoneKilnBlockEntity blockEntity) {
        blockEntity.progressOld = blockEntity.progress;
        switch (blockEntity.animationStatus) {
            case TURN_OVER: {
                blockEntity.progress += 0.1f;
                if (!(blockEntity.progress >= 1.0f)) break;
                blockEntity.progress = 1.0f;
            }
        }
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    public Optional<StoneKilnRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.inventory.getStackInSlot(0));
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)StoneKilnRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public void startTurnOver() {
        ++this.turnOver;
        this.progress = 0.0f;
        this.isTurnOver = false;
        this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, 0);
    }

    public Optional<SmokingRecipe> getSmokerRecipe() {
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.inventory.getStackInSlot(0));
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44110_, (Container)inventory, this.f_58857_);
    }

    private void cookingTick() {
        Optional<StoneKilnRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            StoneKilnRecipe stoneKilnRecipe = currentRecipe.get();
            if (this.maxCookingTime == 0) {
                this.maxCookingTime = this.getAllTime(stoneKilnRecipe.getTime());
            }
            if (this.maxTurnOver == 0) {
                this.maxTurnOver = stoneKilnRecipe.getTime().length - 1;
            }
            this.stoneKilnCookingTick(stoneKilnRecipe);
            return;
        }
        Optional<SmokingRecipe> smokerRecipe = this.getSmokerRecipe();
        if (smokerRecipe.isPresent()) {
            SmokingRecipe smokingRecipe = smokerRecipe.get();
            if (this.maxCookingTime == 0) {
                this.maxCookingTime = smokingRecipe.m_43753_();
            }
            this.smokingCookingTick(smokingRecipe);
            return;
        }
        this.maxCookingTime = 0;
        this.cookingTime = 0;
        this.maxTurnOver = 0;
        this.turnOver = 0;
        this.nextStage = 0;
    }

    private void smokingCookingTick(SmokingRecipe recipe) {
        int time = recipe.m_43753_();
        boolean flag = false;
        ++this.cookingTime;
        if (this.cookingTime >= time) {
            flag = true;
        }
        if (flag) {
            this.inventory.setStackInSlot(0, this.getCookingItem(recipe.m_8043_(null), time));
        }
    }

    private void stoneKilnCookingTick(StoneKilnRecipe recipe) {
        boolean flag = false;
        boolean flags = false;
        int[] times = recipe.getTime();
        if (times.length == 1) {
            if (this.cookingTime < times[0]) {
                ++this.cookingTime;
                this.size += (float)(0.075 / (double)times[0]);
            } else {
                flag = true;
            }
        } else {
            flags = true;
        }
        if (flags) {
            if (this.cookingTime >= this.maxCookingTime) {
                flag = true;
            } else {
                for (int i = this.nextStage; i < times.length; ++i) {
                    this.maxStageCookingTime = times[i];
                    if (this.turnOver == i) {
                        if (this.stageCookingTime < this.maxStageCookingTime) {
                            ++this.stageCookingTime;
                            this.size += (float)(0.075 / (double)this.maxStageCookingTime / (double)times.length);
                            continue;
                        }
                        this.cookingTime += this.stageCookingTime;
                        this.stageCookingTime = 0;
                        this.maxStageCookingTime = 0;
                        if (this.nextStage + 1 >= times.length) continue;
                        ++this.nextStage;
                        continue;
                    }
                    this.isTurnOver = true;
                }
            }
        }
        if (flag) {
            ItemStack resultItem = recipe.m_8043_(null);
            Item item = this.inventory.getStackInSlot(0).m_41720_();
            if (item instanceof CustomPizzaItem) {
                CustomPizzaItem pizzaItem = (CustomPizzaItem)item;
                CompoundTag tag = new CompoundTag();
                List<ItemStack> inventoryList = pizzaItem.getInventoryList(this.inventory.getStackInSlot(0));
                if (!inventoryList.isEmpty()) {
                    ItemStackHandler handler = new ItemStackHandler(4);
                    for (int i = 0; i < inventoryList.size(); ++i) {
                        handler.setStackInSlot(i, inventoryList.get(i));
                    }
                    tag.m_128365_("Inventory", (Tag)handler.serializeNBT());
                    resultItem.m_41751_(tag);
                }
            }
            this.inventory.setStackInSlot(0, resultItem);
        }
    }

    public int getAllTime(int[] times) {
        int time = 0;
        for (int i : times) {
            time += i;
        }
        return time;
    }

    private ItemStack getCookingItem(ItemStack resultItem, int time) {
        if (this.cookingTime >= time + 200) {
            return new ItemStack((ItemLike)Items.f_42413_);
        }
        return resultItem;
    }

    public static enum AnimationStatus {
        STOP,
        TURN_OVER;

    }
}

