/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.toaster;

import com.renyigesai.bakeries.block.oven.OvenBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.recipe.toaster.ToasterRecipe;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ToasterBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private final int[] cooking_times = new int[2];
    private final int[] max_cooking_times = new int[2];

    public ToasterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.TOASTER_ENTITY.get(), pPos, pBlockState);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128385_("cooking_times", this.cooking_times);
        pTag.m_128385_("max_cooking_times", this.max_cooking_times);
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        if (pTag.m_128425_("CookingTimes", 11)) {
            int[] aint = pTag.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cooking_times, 0, Math.min(this.max_cooking_times.length, aint.length));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ToasterBlockEntity pToasterBlockEntity) {
        boolean flag = false;
        ToasterBlockEntity.updateBlock(pToasterBlockEntity);
        ToasterBlockEntity.setFire(pLevel, pPos, pState, pToasterBlockEntity);
        for (int i = 0; i < pToasterBlockEntity.itemHandler.getSlots(); ++i) {
            flag = true;
            ToasterBlockEntity.recipeItem(pLevel, pPos, pState, i, pToasterBlockEntity);
        }
        if (flag) {
            ToasterBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void setFire(Level world, BlockPos pos, BlockState state, ToasterBlockEntity pToasterBlockEntity) {
        boolean isLit = pToasterBlockEntity.cooking_times[0] > 0 || pToasterBlockEntity.cooking_times[1] > 0;
        world.m_7731_(pos, (BlockState)pToasterBlockEntity.m_58900_().m_61124_((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
        world.m_7260_(pos, state, state, 3);
        ToasterBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
    }

    public void addItem(ItemStack item) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            this.itemHandler.setStackInSlot(i, item.m_41620_(1));
            break;
        }
    }

    public void getItem(Player player) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemUtil.givePlayerItem(player, stack);
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_.m_41620_(1));
            break;
        }
    }

    public Vec2 getItemOffset(int i) {
        float x = 0.2f;
        float y = 0.2f;
        Vec2[] offset = new Vec2[]{new Vec2(x, y), new Vec2(-x, y), new Vec2(x, -y), new Vec2(-x, -y)};
        return offset[i];
    }

    public static void updateBlock(ToasterBlockEntity pToasterBlockEntity) {
        Level world = pToasterBlockEntity.m_58904_();
        BlockPos pos = pToasterBlockEntity.m_58899_();
        BlockState state = world.m_8055_(pos);
        ToasterBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        world.m_7260_(pos, state, state, 3);
    }

    private static void recipeItem(Level world, BlockPos pos, BlockState state, int slot, ToasterBlockEntity pToasterBlockEntity) {
        Optional<ToasterRecipe> recipe = pToasterBlockEntity.getCurrentRecipe(slot);
        if (pToasterBlockEntity.hasRecipe(slot) && recipe.isPresent()) {
            if (!world.m_5776_()) {
                int n = slot;
                int n2 = pToasterBlockEntity.cooking_times[n];
                pToasterBlockEntity.cooking_times[n] = n2 + 1;
                int cookingTime = n2;
                int max_cooking_time = pToasterBlockEntity.max_cooking_times[slot];
                if (cookingTime >= max_cooking_time) {
                    pToasterBlockEntity.craftItem(pToasterBlockEntity, slot);
                    world.m_7260_(pos, state, state, 3);
                    ToasterBlockEntity.resetProgress(pToasterBlockEntity, slot);
                }
            }
        } else if (!world.m_5776_()) {
            world.m_7260_(pos, state, state, 3);
            ToasterBlockEntity.resetProgress(pToasterBlockEntity, slot);
        }
    }

    private static void resetProgress(ToasterBlockEntity pToasterBlockEntity, int slot) {
        pToasterBlockEntity.max_cooking_times[slot] = 0;
        pToasterBlockEntity.cooking_times[slot] = 0;
    }

    private void craftItem(ToasterBlockEntity pToasterBlockEntity, int slot) {
        ToasterBlockEntity.updateBlock(pToasterBlockEntity);
        Optional<ToasterRecipe> recipe = this.getCurrentRecipe(slot);
        if (recipe.isPresent()) {
            ItemStack result = recipe.get().m_8043_(null);
            ItemStack takeItem = new ItemStack((ItemLike)result.m_41720_(), result.m_41613_());
            this.itemHandler.setStackInSlot(slot, takeItem);
            ToasterBlockEntity.updateBlock(pToasterBlockEntity);
        }
    }

    private boolean hasRecipe(int slot) {
        Optional<ToasterRecipe> recipe = this.getCurrentRecipe(slot);
        return recipe.isPresent() && ((Ingredient)recipe.get().m_7527_().get(0)).test(this.itemHandler.getStackInSlot(slot));
    }

    public Optional<ToasterRecipe> getCurrentRecipe(int slot) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ToasterRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{this.itemHandler.getStackInSlot(slot)}), this.f_58857_);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

