/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.wooden_tray;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.items.ItemStackHandler;

public class WoodenTrayBlockEntity
extends BlockEntity {
    protected final ItemStackHandler inventory = new ItemStackHandler(2);

    public WoodenTrayBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.WOOD_TRAY_ENTITY.get(), pPos, pBlockState);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean canEmpty() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(ItemStack stack, Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            this.inventory.setStackInSlot(i, stack);
            return true;
        }
        this.m_6596_();
        if (!level.f_46443_) {
            level.m_7260_(pos, state, state, 3);
        }
        return false;
    }

    public void drops(WoodenTrayBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots());
        for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public void takeOutItem(Player player, Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            ItemUtil.givePlayerItem(player, stackInSlot);
            this.inventory.extractItem(i, 1, false);
        }
        this.m_6596_();
        if (!level.f_46443_) {
            level.m_7260_(pos, state, state, 3);
        }
    }

    public Vec2 getItemOffest(int i) {
        float x = this.inventory.getStackInSlot(1).m_41619_() ? 0.0f : -0.15f;
        float y = -0.315f;
        Vec2[] offest = new Vec2[]{new Vec2(x, y), new Vec2(-x, y)};
        return offest[i];
    }
}

