/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.renyigesai.bakeries.block.pizza.CustomPizzaBlockEntity;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CustomPizzaItem
extends BlockItem {
    public CustomPizzaItem(Block block) {
        super(block, new Item.Properties().m_41487_(1).m_41497_(ItemUtil.ADVANCED));
    }

    public List<ItemStack> getInventoryList(ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Inventory", 10)) {
            ItemStackHandler handler = new ItemStackHandler(4);
            handler.deserializeNBT(tag.m_128469_("Inventory"));
            for (int i = 0; i < handler.getSlots(); ++i) {
                stacks.add(handler.getStackInSlot(i));
            }
        }
        return stacks;
    }

    public InteractionResult m_40576_(BlockPlaceContext pContext) {
        BlockPos pos;
        Level level;
        BlockEntity blockEntity;
        if (!pContext.m_43722_().m_150930_((Item)BakeriesItems.CUSTOM_PIZZA.get())) {
            return InteractionResult.FAIL;
        }
        super.m_40576_(pContext);
        List<ItemStack> inventoryList = this.getInventoryList(pContext.m_43722_());
        if (!inventoryList.isEmpty() && (blockEntity = (level = pContext.m_43725_()).m_7702_(pos = pContext.m_8083_())) instanceof CustomPizzaBlockEntity) {
            CustomPizzaBlockEntity entity = (CustomPizzaBlockEntity)blockEntity;
            for (int i = 0; i < entity.getInventory().getSlots(); ++i) {
                ItemStack itemStack = inventoryList.get(i);
                if (itemStack.m_41619_()) continue;
                entity.getInventory().setStackInSlot(i, itemStack);
            }
            List<Object> nutritionAndSaturationMod = this.getNutritionAndSaturationMod(inventoryList);
            entity.setFoodProperties((Integer)nutritionAndSaturationMod.get(0), ((Float)nutritionAndSaturationMod.get(1)).floatValue());
        }
        return InteractionResult.SUCCESS;
    }

    public List<Object> getNutritionAndSaturationMod(List<ItemStack> stacks) {
        ArrayList<Object> list = new ArrayList<Object>();
        int nutrition = 0;
        float saturationMod = 0.0f;
        for (ItemStack itemStack : stacks) {
            FoodProperties foodProperties = itemStack.getFoodProperties(null);
            if (foodProperties == null) continue;
            nutrition += foodProperties.m_38744_();
            saturationMod += foodProperties.m_38745_();
        }
        list.add(nutrition);
        list.add(Float.valueOf(saturationMod));
        return list;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"item.bakeries.custom_containing.tips").getString()).m_130940_(ChatFormatting.BLUE));
        List<ItemStack> inventoryList = this.getInventoryList(pStack);
        if (!inventoryList.isEmpty()) {
            for (ItemStack itemStack : inventoryList) {
                if (itemStack.m_41619_()) continue;
                pTooltip.add((Component)Component.m_237113_((String)itemStack.m_41720_().m_7626_(itemStack).getString()).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

