/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.renyigesai.bakeries.init.BakeriesItemTag;
import com.renyigesai.bakeries.recipe.flour_sieve.FlourSieveRecipe;
import com.renyigesai.bakeries.util.RandomText;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FlourSieveItem
extends Item {
    public FlourSieveItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_12331_;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_12331_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack mainHandItem = pPlayer.m_21205_();
        if (!mainHandItem.m_204117_(BakeriesItemTag.FLOUR)) {
            pPlayer.m_36335_().m_41524_((Item)this, 20);
            pPlayer.m_5661_((Component)Component.m_237115_((String)RandomText.getFlourSieveRandomText()), true);
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        pPlayer.m_6672_(pUsedHand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)pPlayer.m_21120_(pUsedHand));
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        Player player = (Player)pLivingEntity;
        ItemStack mainHandItem = player.m_21205_();
        Optional<FlourSieveRecipe> recipe = this.getCurrentRecipe(player, pLevel);
        if (this.hasRecipe(player, player.m_9236_()) && recipe.isPresent()) {
            if (!player.m_150110_().f_35937_) {
                mainHandItem.m_41774_(1);
                pStack.m_220157_(1, RandomSource.m_216327_(), null);
            }
            player.m_150109_().m_150079_(recipe.get().m_8043_(null));
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public boolean hasRecipe(Player player, Level pLevel) {
        Optional<FlourSieveRecipe> recipe = this.getCurrentRecipe(player, pLevel);
        return recipe.isPresent() && ((Ingredient)recipe.get().m_7527_().get(0)).test(player.m_21205_());
    }

    public Optional<FlourSieveRecipe> getCurrentRecipe(Player player, Level pLevel) {
        return pLevel.m_7465_().m_44015_((RecipeType)FlourSieveRecipe.Type.INSTANCE, (Container)new SimpleContainer(new ItemStack[]{player.m_21205_()}), pLevel);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.EAT;
    }

    public int m_8105_(ItemStack pStack) {
        return 16;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.bakeries.tips.flour_sieve").m_130940_(ChatFormatting.BLUE));
    }
}

