/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.item;

import com.renyigesai.bakeries.block.stone_kiln.StoneKilnBlockEntity;
import com.renyigesai.bakeries.util.ItemUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class StoneKilnShovelItem
extends ShovelItem {
    public StoneKilnShovelItem() {
        super((Tier)Tiers.WOOD, 1.5f, -3.0f, new Item.Properties());
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (player == null) {
            return super.m_6225_(pContext);
        }
        if (blockEntity instanceof StoneKilnBlockEntity) {
            ItemStack itemInHand;
            Item item;
            StoneKilnBlockEntity kiln = (StoneKilnBlockEntity)blockEntity;
            if (player.m_6144_() && (item = (itemInHand = player.m_21120_(pContext.m_43724_())).m_41720_()) instanceof StoneKilnShovelItem) {
                StoneKilnShovelItem shovelItem = (StoneKilnShovelItem)item;
                if (!kiln.isEmpty() && shovelItem.isEmpty(itemInHand)) {
                    this.addItem(player.m_21120_(pContext.m_43724_()), kiln.getInventory().getStackInSlot(0).m_41777_());
                    kiln.getInventory().setStackInSlot(0, ItemStack.f_41583_);
                    level.m_5594_(null, pos, SoundEvents.f_12591_, SoundSource.BLOCKS, 0.8f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6225_(pContext);
    }

    public boolean isEmpty(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("Inventory", 10)) {
            return true;
        }
        ItemStackHandler handler = new ItemStackHandler(1);
        handler.deserializeNBT(tag.m_128469_("Inventory"));
        return handler.getStackInSlot(0).m_41619_();
    }

    public ItemStack getInventoryStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Inventory", 10)) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.deserializeNBT(tag.m_128469_("Inventory"));
            return handler.getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public void addItem(ItemStack stack, ItemStack addStack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Inventory", 10)) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.deserializeNBT(tag.m_128469_("Inventory"));
            if (handler.getStackInSlot(0).m_41619_()) {
                handler.setStackInSlot(0, addStack);
                tag.m_128365_("Inventory", (Tag)handler.serializeNBT());
                stack.m_41751_(tag);
            }
        } else {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, addStack);
            tag.m_128365_("Inventory", (Tag)handler.serializeNBT());
            stack.m_41751_(tag);
        }
    }

    public void removeItem(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_("Inventory", 10)) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.deserializeNBT(tag.m_128469_("Inventory"));
            handler.setStackInSlot(0, ItemStack.f_41583_);
            tag.m_128365_("Inventory", (Tag)handler.serializeNBT());
            stack.m_41751_(tag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack itemstack) {
        return !this.isEmpty(itemstack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack hand = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6144_() && !this.isEmpty(hand)) {
            ItemUtil.givePlayerItem(pPlayer, this.getInventoryStack(hand).m_41777_());
            this.removeItem(hand);
            pPlayer.m_6672_(pUsedHand);
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 0.8f);
            return InteractionResultHolder.m_19090_((Object)hand);
        }
        if (!this.isEmpty(hand)) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        BlockHitResult raytraceresult = StoneKilnShovelItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!(raytraceresult instanceof BlockHitResult)) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        BlockHitResult ray = raytraceresult;
        Vec3 hitVec = ray.m_82450_();
        AABB bb = new AABB(hitVec, hitVec).m_82400_(1.0);
        ItemEntity resultItemEntity = null;
        for (ItemEntity e : pLevel.m_45976_(ItemEntity.class, bb)) {
            if (e.m_32055_().m_41613_() != 1) continue;
            resultItemEntity = e;
            break;
        }
        if (resultItemEntity == null) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        this.addItem(hand, resultItemEntity.m_32055_());
        pLevel.m_6263_(null, resultItemEntity.m_20185_(), resultItemEntity.m_20186_(), resultItemEntity.m_20189_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 0.8f);
        resultItemEntity.m_142687_(Entity.RemovalReason.KILLED);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19090_((Object)hand);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        ItemStack boxStack = this.getInventoryStack(pStack);
        pTooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"item.bakeries.stone_kiln_shovel.tips").getString()).m_130940_(ChatFormatting.BLUE));
        if (!boxStack.m_41619_()) {
            pTooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"item.bakeries.containing.tips").getString()).m_130940_(ChatFormatting.BLUE));
            pTooltip.add((Component)Component.m_237113_((String)boxStack.m_41720_().m_7626_(boxStack).getString()).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
    }
}

