/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jei_recipes;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.inventory.blender.BlenderScreen;
import com.renyigesai.bakeries.inventory.oven.OvenScreen;
import com.renyigesai.bakeries.jei_recipes.BlenderCategory;
import com.renyigesai.bakeries.jei_recipes.BreadKnifeRecipeCategory;
import com.renyigesai.bakeries.jei_recipes.DoughCraftingTableRecipeCategory;
import com.renyigesai.bakeries.jei_recipes.DrinkRecipeCategory;
import com.renyigesai.bakeries.jei_recipes.FlourSieveRecipeCategory;
import com.renyigesai.bakeries.jei_recipes.OvenRecipeCategory;
import com.renyigesai.bakeries.jei_recipes.StoneKilnCategory;
import com.renyigesai.bakeries.recipe.BlenderRecipe;
import com.renyigesai.bakeries.recipe.BreadKnifeRecipe;
import com.renyigesai.bakeries.recipe.CoffeeRecipe;
import com.renyigesai.bakeries.recipe.DoughCraftingRecipe;
import com.renyigesai.bakeries.recipe.StoneKilnRecipe;
import com.renyigesai.bakeries.recipe.flour_sieve.FlourSieveRecipe;
import com.renyigesai.bakeries.recipe.oven.OvenRecipe;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class BakeryJeiPlugin
implements IModPlugin {
    public static final RecipeType<OvenRecipe> Oven_Type = new RecipeType(OvenRecipeCategory.UID, OvenRecipe.class);
    public static final RecipeType<DoughCraftingRecipe> Dough_Crafting_Table_Type = new RecipeType(DoughCraftingTableRecipeCategory.UID, DoughCraftingRecipe.class);
    public static final RecipeType<BlenderRecipe> BLENDER_TYPE = new RecipeType(BlenderCategory.UID, BlenderRecipe.class);
    public static final RecipeType<BreadKnifeRecipe> BREAD_KNIFE_TYPE = new RecipeType(BreadKnifeRecipeCategory.UID, BreadKnifeRecipe.class);
    public static final RecipeType<FlourSieveRecipe> FLOUR_SIEVE_TYPE = new RecipeType(FlourSieveRecipeCategory.UID, FlourSieveRecipe.class);
    public static final RecipeType<CoffeeRecipe> DRINK_TYPE = new RecipeType(DrinkRecipeCategory.UID, CoffeeRecipe.class);
    public static final RecipeType<StoneKilnRecipe> STONE_KILN_TYPE = new RecipeType(StoneKilnCategory.UID, StoneKilnRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("bakeries", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new OvenRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DoughCraftingTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlenderCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BreadKnifeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FlourSieveRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DrinkRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StoneKilnCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List SoundCollectorRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OvenRecipe.Type.INSTANCE);
        registration.addRecipes(Oven_Type, SoundCollectorRecipes);
        List doughCraftingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)DoughCraftingRecipe.Type.INSTANCE);
        registration.addRecipes(Dough_Crafting_Table_Type, doughCraftingRecipes);
        List blenderRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)BlenderRecipe.Type.INSTANCE);
        registration.addRecipes(BLENDER_TYPE, blenderRecipes);
        List breadKnifeRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)BreadKnifeRecipe.Type.INSTANCE);
        registration.addRecipes(BREAD_KNIFE_TYPE, breadKnifeRecipes);
        List flourSieveRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)FlourSieveRecipe.Type.INSTANCE);
        registration.addRecipes(FLOUR_SIEVE_TYPE, flourSieveRecipes);
        List drinkRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CoffeeRecipe.Type.INSTANCE);
        registration.addRecipes(DRINK_TYPE, drinkRecipes);
        List stoneRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)StoneKilnRecipe.Type.INSTANCE);
        registration.addRecipes(STONE_KILN_TYPE, stoneRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(OvenScreen.class, 110, 16, 8, 54, new RecipeType[]{Oven_Type});
        registration.addRecipeClickArea(BlenderScreen.class, 136, 38, 13, 10, new RecipeType[]{BLENDER_TYPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesBlocks.OVEN.get()), new RecipeType[]{Oven_Type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesBlocks.DOUGH_CRAFTING_TABLE.get()), new RecipeType[]{Dough_Crafting_Table_Type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesBlocks.BLENDER.get()), new RecipeType[]{BLENDER_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesItems.BREAD_KNIFE.get()), new RecipeType[]{BREAD_KNIFE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesItems.FLOUR_SIEVE.get()), new RecipeType[]{FLOUR_SIEVE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesItems.DRINK_CUP.get()), new RecipeType[]{DRINK_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BakeriesBlocks.STONE_KILN.get()), new RecipeType[]{STONE_KILN_TYPE});
    }
}

