/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.jei_recipes;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.jei_recipes.BakeryJeiPlugin;
import com.renyigesai.bakeries.recipe.oven.OvenRecipe;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OvenRecipeCategory
implements IRecipeCategory<OvenRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("bakeries", "oven_recipe");
    public static final ResourceLocation TEXTURE = new ResourceLocation("bakeries", "textures/gui/jei_oven_gui.png");
    protected final IDrawable background;
    protected final IDrawable icon;
    private final IDrawable cachedArrows;

    public OvenRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 58, 63);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BakeriesBlocks.OVEN.get()));
        this.cachedArrows = helper.createDrawable(TEXTURE, 0, 70, 20, 3);
    }

    public void draw(OvenRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int cookTime = recipe.getTime();
        Minecraft minecraft = Minecraft.m_91087_();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(fontRenderer, (Component)timeString, 39 - stringWidth, 27, -8355712, false);
        }
        if (mouseX >= 44.0 && mouseX <= 53.0 && mouseY >= 7.0 && mouseY <= 55.0) {
            this.renderTemperatureTooltip(minecraft, guiGraphics, mouseX, mouseY, recipe);
        }
    }

    protected void renderTemperatureTooltip(Minecraft minecraft, GuiGraphics gui, double mouseX, double mouseY, OvenRecipe recipe) {
        if (minecraft != null && minecraft.f_91074_ != null) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)("Min " + recipe.getMin_temperature() + "\u00b0C")).m_130940_(ChatFormatting.BLUE));
            tooltip.add(Component.m_237113_((String)("Max " + recipe.getMax_temperature() + "\u00b0C")).m_130940_(ChatFormatting.BLUE));
            gui.m_280666_(minecraft.f_91062_, tooltip, (int)mouseX, (int)mouseY);
        }
    }

    public @NotNull RecipeType<OvenRecipe> getRecipeType() {
        return BakeryJeiPlugin.Oven_Type;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"container.oven");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 8).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 15, 38).addItemStack(recipe.m_8043_(null));
    }
}

