/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.renyigesai.bakeries.block.stone_kiln.StoneKilnBlockEntity;
import com.renyigesai.bakeries.client.LookBlockEntityMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class StoneKilnOverlay {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void add(RenderGuiEvent.Pre event) {
        int w = event.getWindow().m_85445_() / 2 - 56 - 23;
        int h = event.getWindow().m_85446_() / 2 + 15;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        if (localPlayer == null) {
            return;
        }
        Map<UUID, BlockEntity> blocks = LookBlockEntityMap.getBlocks();
        BlockEntity blockEntity = blocks.get(localPlayer.m_20148_());
        if (blockEntity instanceof StoneKilnBlockEntity) {
            StoneKilnBlockEntity stoneKilnBlockEntity = (StoneKilnBlockEntity)blockEntity;
            float scale = 1.5f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)w, (float)h, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            guiGraphics.m_280163_(new ResourceLocation("bakeries:textures/gui/stone_kiln_progress_bar.png"), 0, 0, 0.0f, 0.0f, 103, 40, 103, 46);
            int progressWidth = StoneKilnOverlay.getProgressWidth(stoneKilnBlockEntity);
            guiGraphics.m_280163_(new ResourceLocation("bakeries:textures/gui/stone_kiln_progress_bar.png"), 13, 19, 0.0f, 40.0f, progressWidth, 6, 103, 46);
            int maxTurnOver = stoneKilnBlockEntity.getMaxTurnOver();
            if (maxTurnOver != 0) {
                String string = maxTurnOver + "/" + stoneKilnBlockEntity.getTurnOver();
                guiGraphics.m_280430_(mc.f_91062_, Component.m_130674_((String)string), 44, 9, 0xFFFFFF);
            }
            guiGraphics.m_280168_().m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static int getProgressWidth(StoneKilnBlockEntity stoneKilnBlockEntity) {
        if (stoneKilnBlockEntity.getMaxStageCookingTime() != 0) {
            return 80 * stoneKilnBlockEntity.getStageCookingTime() / stoneKilnBlockEntity.getMaxStageCookingTime();
        }
        if (stoneKilnBlockEntity.getMaxCookingTime() != 0) {
            return 80 * stoneKilnBlockEntity.getCookingTime() / stoneKilnBlockEntity.getMaxCookingTime();
        }
        return 0;
    }
}

