/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneKilnRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final int[] time;
    private final ResourceLocation id;

    public StoneKilnRecipe(NonNullList<Ingredient> ingredient, ItemStack output, int[] time, ResourceLocation id) {
        this.inputItems = ingredient;
        this.output = output;
        this.time = time;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        return ((Ingredient)this.inputItems.get(0)).test(pContainer.m_8020_(0));
    }

    public int[] getTime() {
        return this.time;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<StoneKilnRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("bakeries", "stone_kiln");

        public StoneKilnRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            int[] time;
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            if (pSerializedRecipe.has("cooking_time") && pSerializedRecipe.get("cooking_time").isJsonArray()) {
                JsonArray timeArray = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"cooking_time");
                time = new int[timeArray.size()];
                for (int i = 0; i < timeArray.size(); ++i) {
                    time[i] = timeArray.get(i).getAsInt();
                }
            } else if (pSerializedRecipe.has("cooking_time")) {
                time = new int[]{GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"cooking_time")};
            } else {
                throw new JsonParseException("Missing cooking_time in recipe");
            }
            inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(0)));
            return new StoneKilnRecipe((NonNullList<Ingredient>)inputs, output, time, pRecipeId);
        }

        @Nullable
        public StoneKilnRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int ingredientCount = pBuffer.readInt();
            int timeLength = pBuffer.m_130242_();
            int[] time = new int[timeLength];
            for (int i = 0; i < timeLength; ++i) {
                time[i] = pBuffer.m_130242_();
            }
            NonNullList inputs = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
            if (inputs.size() > 1) {
                throw new JsonParseException("Too many ingredients for stone kiln recipe! The max is 1");
            }
            inputs.set(0, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            ItemStack output = pBuffer.m_130267_();
            return new StoneKilnRecipe((NonNullList<Ingredient>)inputs, output, time, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, StoneKilnRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            pBuffer.m_130130_(pRecipe.time.length);
            for (int t : pRecipe.time) {
                pBuffer.m_130130_(t);
            }
            Object object = pRecipe.m_7527_().iterator();
            while (object.hasNext()) {
                Ingredient ingredient = (Ingredient)object.next();
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<StoneKilnRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "stone_kiln";
    }
}

