/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.blockentities;

import com.mojang.authlib.GameProfile;
import com.ultramega.playershells.Config;
import com.ultramega.playershells.blocks.AbstractMultiblockBlock;
import com.ultramega.playershells.blocks.ShellForgeBlock;
import com.ultramega.playershells.container.ShellForgeContainerMenu;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.registry.ModBlocks;
import com.ultramega.playershells.registry.ModDataComponentTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.registry.ModSoundEvents;
import com.ultramega.playershells.storage.ShellSavedData;
import com.ultramega.playershells.storage.ShellState;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.ObservableEnergyStorage;
import com.ultramega.playershells.utils.OwnerData;
import com.ultramega.playershells.utils.PositionReference;
import com.ultramega.playershells.utils.ShellPlayer;
import com.ultramega.playershells.utils.SoundHandler;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ShellForgeBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private static final float OPEN_SPEED = 0.12f;
    public final ItemStackHandler inventoryHandler = new ItemStackHandler(1){

        public void onContentsChanged(int slot) {
            ShellForgeBlockEntity.super.setChanged();
        }
    };
    public final ObservableEnergyStorage energyStorage = new ObservableEnergyStorage((int)((Integer)Config.SHELL_FORGE_ENERGY_CAPACITY.get())){

        @Override
        public void onEnergyChanged() {
            ShellForgeBlockEntity.this.setChanged();
        }
    };
    private UUID playerUuid = MathUtils.EMPTY_UUID;
    private PlayerStates playerState = PlayerStates.NONE;
    private UUID shellUuid = MathUtils.EMPTY_UUID;
    private ShellStates shellState = ShellStates.CREATE;
    private int shellPercentage;
    private int shellPercentageCooldownTick;
    private float animProgress;
    private float animPrevProgress;

    public ShellForgeBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.SHELL_FORGE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ShellForgeBlockEntity blockEntity) {
        blockEntity.updatePlayerStateAndOpened(state, pos);
        blockEntity.drainEnergyPassive();
        if (blockEntity.shellState == ShellStates.DECAYING || blockEntity.shellState == ShellStates.EXTERMINATING) {
            if (blockEntity.shellPercentage <= 0) {
                blockEntity.exterminateShell();
                return;
            }
            if (blockEntity.shellState == ShellStates.DECAYING && blockEntity.shellPercentageCooldownTick++ <= (Integer)Config.SHELL_FORGE_DECAY_COOLDOWN.get()) {
                blockEntity.setChanged();
                return;
            }
            blockEntity.shellPercentageCooldownTick = 0;
            --blockEntity.shellPercentage;
            blockEntity.updateShellCreationProgressOnClient();
            blockEntity.setChanged();
        }
        if (blockEntity.shellState != ShellStates.CREATING) {
            return;
        }
        if (blockEntity.shellPercentage == 100) {
            blockEntity.shellState = ShellStates.EXTERMINATE;
            blockEntity.setChanged();
            return;
        }
        if (blockEntity.shellPercentageCooldownTick++ <= (Integer)Config.SHELL_FORGE_CREATION_COOLDOWN.get()) {
            blockEntity.setChanged();
            return;
        }
        blockEntity.shellPercentageCooldownTick = 0;
        ++blockEntity.shellPercentage;
        blockEntity.updateShellCreationProgressOnClient();
        blockEntity.setChanged();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level level, BlockPos pos, BlockState state, ShellForgeBlockEntity blockEntity) {
        LocalPlayer player;
        float target;
        blockEntity.animPrevProgress = blockEntity.animProgress;
        float f = target = (Boolean)state.getValue((Property)ShellForgeBlock.OPEN) != false ? 1.0f : 0.0f;
        if (blockEntity.animProgress < target) {
            blockEntity.animProgress = Math.min(target, blockEntity.animProgress + 0.12f);
        } else if (blockEntity.animProgress > target) {
            blockEntity.animProgress = Math.max(target, blockEntity.animProgress - 0.12f);
        }
        if (blockEntity.shellState == ShellStates.EXTERMINATING) {
            if (level.random.nextDouble() < 0.1) {
                SoundHandler.startBlockSound((SoundEvent)ModSoundEvents.FLAMETHROWER.get(), SoundSource.BLOCKS, 1.5f, 1.0f, level.random, pos);
            }
        } else {
            SoundHandler.stopAllBlockSounds(pos);
        }
        if ((player = Minecraft.getInstance().player) == null || !((Boolean)state.getValue((Property)ShellForgeBlock.OPEN)).booleanValue()) {
            return;
        }
        if (blockEntity.playerState == PlayerStates.GOING_IN || blockEntity.playerState == PlayerStates.INSIDE) {
            ShellForgeBlock.movePlayerInside((Player)player, pos, (Direction)state.getValue((Property)AbstractMultiblockBlock.FACING));
        } else if (blockEntity.playerState == PlayerStates.GOING_OUT) {
            ShellForgeBlock.movePlayerTo((Player)player, pos.relative((Direction)state.getValue((Property)AbstractMultiblockBlock.FACING)), 0.0);
        }
    }

    private void drainEnergyPassive() {
        if (this.shellState == ShellStates.EXTERMINATE) {
            int simulateExtract = this.energyStorage.extractEnergy((Integer)Config.SHELL_FORGE_ENERGY_USAGE_MAINTENANCE.get(), true);
            if (simulateExtract != (Integer)Config.SHELL_FORGE_ENERGY_USAGE_MAINTENANCE.get()) {
                this.shellState = ShellStates.DECAYING;
                this.setChanged();
            } else {
                this.energyStorage.extractEnergy((Integer)Config.SHELL_FORGE_ENERGY_USAGE_MAINTENANCE.get(), false);
                this.setChanged();
            }
        }
    }

    private void updateShellCreationProgressOnClient() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShellSavedData.getShellData(serverLevel).updateShellCreationProgress(this.playerUuid, this.shellUuid, this.shellPercentage);
        }
    }

    public void transferPlayerTo(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ShellPlayer) {
                ShellPlayer shellPlayer = (ShellPlayer)player;
                ShellState shellState = ShellSavedData.getShellData(serverLevel).get(this.playerUuid, this.shellUuid);
                if (shellState != null) {
                    shellPlayer.playershells$applyData(shellState.playerData(), shellState.shellForgePos());
                    this.playerState = PlayerStates.TRANSFERRED;
                    this.exterminateShell();
                    ShellForgeBlock.setValue(this.getBlockState(), this.level, this.getBlockPos(), new ShellForgeBlock.BoolProperty(ShellForgeBlock.OPEN, true));
                }
            }
        }
    }

    public void transferPlayerFrom(Player player) {
        this.setPlayerUuid(player.getUUID());
        this.shellState = ShellStates.EXTERMINATE;
        this.playerState = PlayerStates.NONE;
        this.shellPercentage = 100;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ShellPlayer) {
                ShellPlayer shellPlayer = (ShellPlayer)player;
                this.shellUuid = UUID.randomUUID();
                ShellSavedData.getShellData(serverLevel).add(this.playerUuid, new ShellState(this.shellUuid, new PositionReference(this.getBlockPos(), (Direction)this.getBlockState().getValue((Property)AbstractMultiblockBlock.FACING), this.level.dimension().location()), shellPlayer.playershells$getData(), 100));
            }
        }
        this.setChanged();
    }

    public void createShell() {
        if (!this.canCreateShell()) {
            return;
        }
        UUID playerUUID = Objects.requireNonNull((OwnerData)this.inventoryHandler.getStackInSlot(0).get(ModDataComponentTypes.OWNER_PLAYER.get())).playerUUID();
        this.energyStorage.extractEnergy((Integer)Config.SHELL_FORGE_ENERGY_USAGE_CREATION.get(), false);
        this.inventoryHandler.extractItem(0, 64, false);
        this.setPlayerUuid(playerUUID);
        this.shellState = ShellStates.CREATING;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.shellUuid = UUID.randomUUID();
            ShellSavedData.getShellData(serverLevel).add(this.playerUuid, new ShellState(this.shellUuid, new PositionReference(this.getBlockPos(), (Direction)this.getBlockState().getValue((Property)AbstractMultiblockBlock.FACING), this.level.dimension().location()), this.createFreshPlayerData(serverLevel), 0));
        }
        this.setChanged();
    }

    public void exterminateShell() {
        this.setPlayerUuid(MathUtils.EMPTY_UUID);
        this.shellPercentage = 0;
        this.shellState = ShellStates.CREATE;
        this.shellUuid = MathUtils.EMPTY_UUID;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShellSavedData.getShellData(serverLevel).validateShellData((Level)serverLevel);
        }
        this.setChanged();
    }

    private CompoundTag createFreshPlayerData(ServerLevel serverLevel) {
        CommonListenerCookie cookie = CommonListenerCookie.createInitial((GameProfile)new GameProfile(UUID.randomUUID(), ""), (boolean)false);
        return new ServerPlayer(serverLevel.getServer(), serverLevel, cookie.gameProfile(), cookie.clientInformation()).saveWithoutId(new CompoundTag());
    }

    public boolean canCreateShell() {
        boolean canExtractStack;
        int energyNeeded = (Integer)Config.SHELL_FORGE_ENERGY_USAGE_CREATION.get();
        ItemStack stack = this.inventoryHandler.getStackInSlot(0);
        if (stack.isEmpty() || !stack.is(ModItems.DNA) || !stack.has(ModDataComponentTypes.OWNER_PLAYER.get())) {
            return false;
        }
        boolean bl = canExtractStack = this.inventoryHandler.extractItem(0, 64, true).getCount() >= 64;
        if (!canExtractStack) {
            return false;
        }
        int simulatedExtract = this.energyStorage.extractEnergy(energyNeeded, true);
        return simulatedExtract >= energyNeeded;
    }

    private void updatePlayerStateAndOpened(BlockState state, BlockPos pos) {
        if (this.level == null) {
            return;
        }
        if (!(ShellForgeBlock.isOpen(state) || this.playerState != PlayerStates.GOING_IN && this.playerState != PlayerStates.TRANSFERRED)) {
            ShellForgeBlock.setValue(state, this.level, pos, new ShellForgeBlock.BoolProperty(ShellForgeBlock.OPEN, true));
        } else if (this.playerState == PlayerStates.GOING_IN) {
            if (MathUtils.hasPlayerInside(pos, this.level)) {
                this.playerState = PlayerStates.INSIDE;
                this.setChanged();
            }
        } else if (!MathUtils.hasPlayerInside(pos, this.level)) {
            this.playerState = PlayerStates.NONE;
            this.setChanged();
            ShellForgeBlock.setValue(state, this.level, pos, new ShellForgeBlock.BoolProperty(ShellForgeBlock.OPEN, false));
        }
    }

    public void shellButtonPressed() {
        if (this.shellState == ShellStates.CREATE) {
            this.createShell();
        } else if (this.shellState == ShellStates.EXTERMINATE) {
            this.shellState = ShellStates.EXTERMINATING;
            this.setChanged();
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inv")) {
            this.inventoryHandler.deserializeNBT(registries, tag.getCompound("inv"));
        }
        if (tag.contains("energy")) {
            this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        }
        if (tag.contains("playerUuid")) {
            this.playerUuid = tag.getUUID("playerUuid");
        }
        if (tag.contains("playerState")) {
            this.playerState = PlayerStates.values()[tag.getInt("playerState")];
        }
        if (tag.contains("shellUuid")) {
            this.shellUuid = tag.getUUID("shellUuid");
        }
        if (tag.contains("shellState")) {
            this.shellState = ShellStates.values()[tag.getInt("shellState")];
        }
        if (tag.contains("shellPercentage")) {
            this.shellPercentage = tag.getInt("shellPercentage");
        }
        if (tag.contains("shellPercentageCooldownTick")) {
            this.shellPercentageCooldownTick = tag.getInt("shellPercentageCooldownTick");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inv", (Tag)this.inventoryHandler.serializeNBT(registries));
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.putUUID("playerUuid", this.playerUuid);
        tag.putInt("playerState", this.playerState.ordinal());
        tag.putUUID("shellUuid", this.shellUuid);
        tag.putInt("shellState", this.shellState.ordinal());
        tag.putInt("shellPercentage", this.shellPercentage);
        tag.putInt("shellPercentageCooldownTick", this.shellPercentageCooldownTick);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void setPlayerUuid(UUID uuid) {
        this.playerUuid = uuid;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public UUID getShellUuid() {
        return this.shellUuid;
    }

    public ShellStates getShellState() {
        return this.shellState;
    }

    public void setPlayerState(PlayerStates playerState) {
        this.playerState = playerState;
    }

    public PlayerStates getPlayerState() {
        return this.playerState;
    }

    public int getShellPercentage() {
        return this.shellPercentage;
    }

    public float getAnimPrevProgress() {
        return this.animPrevProgress;
    }

    public float getAnimProgress() {
        return this.animProgress;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.SHELL_FORGE.get()).getDescriptionId());
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new ShellForgeContainerMenu(containerId, inventory, this, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()));
    }

    public static enum PlayerStates {
        NONE,
        GOING_IN,
        INSIDE,
        GOING_OUT,
        TRANSFERRED;

    }

    public static enum ShellStates {
        CREATE,
        CREATING,
        EXTERMINATE,
        EXTERMINATING,
        DECAYING;

    }
}

