/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.blockentities.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.blocks.AbstractMultiblockBlock;
import com.ultramega.playershells.entities.ShellEntity;
import com.ultramega.playershells.events.ClientEvents;
import com.ultramega.playershells.registry.ModRenderTypes;
import com.ultramega.playershells.storage.ClientShellData;
import com.ultramega.playershells.storage.ShellState;
import com.ultramega.playershells.utils.MathUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class ShellForgeBlockEntityRenderer
implements BlockEntityRenderer<ShellForgeBlockEntity> {
    private static final Map<UUID, ShellEntity> SHELL_CACHE = new HashMap<UUID, ShellEntity>();
    private static final int FLAME_STRAY_COUNT = 50;
    private static final float FLAME_STRAY_WIDTH = 0.03f;
    private static final float FLAME_RADIUS = 0.25f;
    private static final int[] YELLOW = new int[]{247, 223, 37};
    private static final int[] ORANGE = new int[]{255, 140, 0};
    private static final int[] DARK_ORANGE = new int[]{153, 84, 1};
    private final BlockRenderDispatcher blockRenderer;

    public ShellForgeBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderer = ctx.getBlockRenderDispatcher();
    }

    public void render(ShellForgeBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        float yaw;
        if (!AbstractMultiblockBlock.isBottomHalf(blockEntity.getBlockState())) {
            return;
        }
        this.renderGlassPanels(blockEntity, partialTick, poseStack, buffers, packedLight, packedOverlay);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        UUID playerUuid = blockEntity.getPlayerUuid();
        UUID shellUuid = blockEntity.getShellUuid();
        if (playerUuid.equals(MathUtils.EMPTY_UUID) || shellUuid.equals(MathUtils.EMPTY_UUID)) {
            return;
        }
        if (blockEntity.getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATING && blockEntity.getLevel() != null) {
            this.renderSmallFlame(poseStack, buffers, blockEntity.getLevel().random, packedLight);
        }
        ShellEntity shellPlayer = ShellForgeBlockEntityRenderer.getPlayerShellFromCache(mc.level, playerUuid, shellUuid, SHELL_CACHE);
        shellPlayer.setPos(blockEntity.getBlockPos().getCenter().subtract(0.0, 0.4, 0.0));
        shellPlayer.yBodyRotO = yaw = MathUtils.yawForDirection((Direction)blockEntity.getBlockState().getValue((Property)AbstractMultiblockBlock.FACING));
        shellPlayer.yBodyRot = yaw;
        shellPlayer.setYRot(yaw);
        shellPlayer.yHeadRotO = yaw;
        shellPlayer.yHeadRot = yaw;
        shellPlayer.setXRot(0.0f);
        EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
        ResourceLocation skinTexture = dispatcher.getRenderer((Entity)shellPlayer).getTextureLocation((Entity)shellPlayer);
        int color = blockEntity.getShellState() == ShellForgeBlockEntity.ShellStates.CREATING ? MathUtils.packRGB8(54, 188, 184) : MathUtils.packRGB8(53, 53, 53);
        RenderType renderType = (RenderType)ModRenderTypes.CREATE_SHADER_TYPE.apply((Object)skinTexture, (Object)shellPlayer, (Object)blockEntity.getShellPercentage(), (Object)1, (Object)color);
        ShaderForcingBuffer remappedBuffer = new ShaderForcingBuffer(buffers, renderType, blockEntity.getShellState() == ShellForgeBlockEntity.ShellStates.CREATING || blockEntity.getShellState() == ShellForgeBlockEntity.ShellStates.DECAYING || blockEntity.getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0625, 0.5);
        dispatcher.setRenderShadow(false);
        dispatcher.render((Entity)shellPlayer, 0.0, 0.0, 0.0, yaw, partialTick, poseStack, (MultiBufferSource)remappedBuffer, packedLight);
        dispatcher.setRenderShadow(true);
        poseStack.popPose();
    }

    private void renderSmallFlame(PoseStack poseStack, MultiBufferSource buffers, RandomSource random, int packedLight) {
        VertexConsumer vertexConsumer = buffers.getBuffer(RenderType.debugQuads());
        for (int i = 0; i < 50; ++i) {
            float height = 1.6f + (random.nextFloat() - 0.5f) * 0.7f;
            float startY = -height + 2.0f;
            float angleRad = (float)((double)((float)i / 50.0f) * (Math.PI * 2));
            float baseX = 0.5f + (float)Math.cos(angleRad) * 0.25f;
            float baseZ = 0.5f + (float)Math.sin(angleRad) * 0.25f;
            float angle = random.nextFloat() * 360.0f;
            poseStack.pushPose();
            poseStack.translate(baseX, startY + height / 2.0f, baseZ);
            poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            poseStack.translate(-baseX, -(startY + height / 2.0f), -baseZ);
            Matrix4f matrix = poseStack.last().pose();
            int steps = 10;
            for (int j = 0; j < 10; ++j) {
                float y1 = startY + (float)j / 10.0f * height;
                float y2 = startY + (float)(j + 1) / 10.0f * height;
                float t1 = (y1 - startY) / height;
                float t2 = (y2 - startY) / height;
                float widthFactor1 = (float)Math.sin((double)t1 * Math.PI);
                float widthFactor2 = (float)Math.sin((double)t2 * Math.PI);
                float w1 = 0.03f + 0.25f * widthFactor1;
                float w2 = 0.03f + 0.25f * widthFactor2;
                float midT = (float)j / 10.0f;
                float midT2 = (float)(j + 1) / 10.0f;
                int[] color1 = MathUtils.interpolateGradient(midT, DARK_ORANGE, ORANGE, YELLOW);
                int[] color2 = MathUtils.interpolateGradient(midT2, DARK_ORANGE, ORANGE, YELLOW);
                vertexConsumer.addVertex(matrix, baseX - w1 / 2.0f, y1, baseZ).setColor(color1[0], color1[1], color1[2], 200).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight);
                vertexConsumer.addVertex(matrix, baseX - w2 / 2.0f, y2, baseZ).setColor(color2[0], color2[1], color2[2], 200).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight);
                vertexConsumer.addVertex(matrix, baseX + w2 / 2.0f, y2, baseZ).setColor(color2[0], color2[1], color2[2], 200).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight);
                vertexConsumer.addVertex(matrix, baseX + w1 / 2.0f, y1, baseZ).setColor(color1[0], color1[1], color1[2], 200).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight);
            }
            poseStack.popPose();
        }
    }

    private void renderGlassPanels(ShellForgeBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        float leftAngleDeg = this.getAngle(partialTick, blockEntity);
        float rightAngleDeg = -leftAngleDeg;
        float yaw = switch ((Direction)blockEntity.getBlockState().getValue((Property)AbstractMultiblockBlock.FACING)) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(yaw));
        poseStack.translate(-0.5, 0.0, -0.5);
        VertexConsumer consumer = buffers.getBuffer(Sheets.cutoutBlockSheet());
        poseStack.pushPose();
        float px = 0.925f;
        float py = 0.0f;
        float pz = 0.1f;
        poseStack.translate(px, py, pz);
        poseStack.mulPose(Axis.YP.rotationDegrees(rightAngleDeg));
        poseStack.translate(-px, -py, -pz);
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), consumer, null, ClientEvents.shellForgeGlassRight, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, null);
        poseStack.popPose();
        poseStack.pushPose();
        px = 0.06875f;
        py = 0.0f;
        pz = 0.1f;
        poseStack.translate(px, py, pz);
        poseStack.mulPose(Axis.YP.rotationDegrees(leftAngleDeg));
        poseStack.translate(-px, -py, -pz);
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), consumer, null, ClientEvents.shellForgeGlassLeft, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay, ModelData.EMPTY, null);
        poseStack.popPose();
        poseStack.popPose();
    }

    public float getAngle(float partialTick, ShellForgeBlockEntity blockEntity) {
        float t = Mth.lerp((float)partialTick, (float)blockEntity.getAnimPrevProgress(), (float)blockEntity.getAnimProgress());
        return t * 60.0f;
    }

    public AABB getRenderBoundingBox(ShellForgeBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).expandTowards(0.0, AbstractMultiblockBlock.isBottomHalf(blockEntity.getBlockState()) ? 1.0 : -1.0, 0.0);
    }

    public static ShellEntity getPlayerShellFromCache(ClientLevel level, UUID playerUuid, UUID shellUuid, Map<UUID, ShellEntity> cache) {
        return cache.computeIfAbsent(shellUuid, ignored -> {
            ShellEntity player = new ShellEntity(level, new GameProfile(playerUuid, ""));
            ShellState shellState = ClientShellData.INSTANCE.get(playerUuid, shellUuid);
            if (shellState != null) {
                player.load(shellState.playerData());
            }
            player.setPose(Pose.STANDING);
            return player;
        });
    }

    public static class ShaderForcingBuffer
    implements MultiBufferSource {
        private final MultiBufferSource delegate;
        private final RenderType forced;
        private final boolean replace;

        public ShaderForcingBuffer(MultiBufferSource delegate, RenderType forced, boolean replace) {
            this.delegate = delegate;
            this.forced = forced;
            this.replace = replace;
        }

        public VertexConsumer getBuffer(RenderType requested) {
            if (this.replace && requested.format().equals((Object)this.forced.format()) && requested.mode() == this.forced.mode()) {
                return this.delegate.getBuffer(this.forced);
            }
            return this.delegate.getBuffer(requested);
        }
    }
}

