/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui;

import com.ultramega.playershells.container.CentrifugeContainerMenu;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CentrifugeScreen
extends AbstractContainerScreen<CentrifugeContainerMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"textures/gui/centrifuge.png");
    private static final ResourceLocation PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/furnace/burn_progress");
    private static final int ENERGY_BAR_HEIGHT = 52;

    public CentrifugeScreen(CentrifugeContainerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.getXSize(), this.getYSize());
        graphics.blit(BACKGROUND, this.leftPos + 8, this.topPos + 18, 176, 0, 6, 52);
        int energyAmount = ((CentrifugeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getEnergyStored();
        int energyMaxStored = ((CentrifugeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getMaxEnergyStored();
        int energyLevel = (int)((float)energyAmount * (52.0f / (float)energyMaxStored));
        graphics.blit(BACKGROUND, this.leftPos + 8, this.topPos + 18, 8, 18, 6, 52 - energyLevel);
        int width = Mth.ceil((float)(((CentrifugeContainerMenu)this.menu).getProcessingProgress() * 24.0f));
        graphics.blitSprite(PROGRESS_SPRITE, 24, 16, 0, 0, this.leftPos + 79, this.topPos + 34, width, 16);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
        if (this.isHovering(7, 18, 8, 53, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, List.of(Component.translatable((String)"gui.playershells.energy", (Object[])new Object[]{((CentrifugeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getEnergyStored()}).getVisualOrderText()), mouseX, mouseY);
        }
    }
}

