/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ultramega.playershells.blockentities.renderer.ShellForgeBlockEntityRenderer;
import com.ultramega.playershells.entities.ShellEntity;
import com.ultramega.playershells.gui.RadialMenuRenderer;
import com.ultramega.playershells.storage.ClientShellData;
import com.ultramega.playershells.storage.ShellState;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.ShellBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class ShellSelectionOverlay
extends RadialMenuRenderer<ShellBundle.ShellEntry>
implements LayeredDraw.Layer {
    public static final ShellSelectionOverlay INSTANCE = new ShellSelectionOverlay();
    private static final Map<UUID, ShellEntity> SHELL_CACHE = new HashMap<UUID, ShellEntity>();
    private static final ResourceLocation INVENTORY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"textures/gui/clean_inventory.png");
    @Nullable
    private Consumer<ShellBundle.ShellEntry> onSelectShell;
    @Nullable
    private Runnable onClose;
    @Nullable
    private ShellBundle displayedShell;

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        ShellBundle.ShellEntry shellEntry;
        if (!this.isOpened()) {
            return;
        }
        super.render(graphics);
        ShellBundle.ShellEntry shellEntry2 = shellEntry = this.lastIndexUnderMouse != -1 ? this.getEntries().get(this.lastIndexUnderMouse) : null;
        if (shellEntry == null) {
            return;
        }
        PoseStack pose = graphics.pose();
        float centerX = (float)graphics.guiWidth() / 2.0f;
        float centerY = (float)graphics.guiHeight() / 2.0f;
        int invWidth = 176;
        int invHeight = 166;
        this.renderInventory(graphics, pose, centerX, centerY, 176, 166, shellEntry);
        this.renderStats(graphics, pose, centerX, centerY, 176, 166, shellEntry);
    }

    private void renderInventory(GuiGraphics graphics, PoseStack pose, float centerX, float centerY, int invWidth, int invHeight, ShellBundle.ShellEntry shellEntry) {
        int i;
        if (shellEntry.inventory().isEmpty()) {
            return;
        }
        Function textureAtlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        pose.pushPose();
        pose.translate(centerX - 115.0f - (float)invWidth / 2.0f, centerY - (float)invHeight / 2.0f / 2.0f, 0.0f);
        pose.scale(0.5f, 0.5f, 0.5f);
        graphics.blit(INVENTORY_LOCATION, 0, 0, 0.0f, 0.0f, invWidth, invHeight, 256, 256);
        for (i = 0; i < 4; ++i) {
            ItemStack armorStack = (ItemStack)shellEntry.inventory().get().armor().get(4 - (i + 1));
            if (armorStack.isEmpty()) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlas.apply((ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(InventoryMenu.SLOT_IDS[i]));
                graphics.blit(8, 8 + i * 18, 0, 16, 16, sprite);
                continue;
            }
            this.renderSlotContent(graphics, armorStack, 8, 8 + i * 18, invWidth);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                ItemStack stack = (ItemStack)shellEntry.inventory().get().items().get(j + (i + 1) * 9);
                this.renderSlotContent(graphics, stack, 8 + j * 18, 84 + i * 18, invWidth);
            }
        }
        for (i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)shellEntry.inventory().get().items().get(i);
            this.renderSlotContent(graphics, stack, 8 + i * 18, 142, invWidth);
        }
        ItemStack offHandStack = (ItemStack)shellEntry.inventory().get().offhand().getFirst();
        if (offHandStack.isEmpty()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlas.apply(InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            graphics.blit(77, 62, 0, 16, 16, sprite);
        } else {
            this.renderSlotContent(graphics, offHandStack, 77, 62, invWidth);
        }
        pose.popPose();
    }

    private void renderStats(GuiGraphics graphics, PoseStack pose, float centerX, float centerY, int invWidth, int invHeight, ShellBundle.ShellEntry shellEntry) {
        if (shellEntry.stats().isEmpty()) {
            return;
        }
        float bottomWidth = 82.0f;
        float offsetX = ((float)invWidth / 2.0f - 82.0f) / 2.0f;
        int currentHealth = Mth.ceil((float)shellEntry.stats().get().health());
        pose.pushPose();
        pose.translate(centerX - 115.0f - (float)invWidth / 2.0f + offsetX, centerY - (float)invHeight / 2.0f / 2.0f + (float)invHeight / 2.0f + 10.0f, 0.0f);
        this.renderArmor(graphics, shellEntry.stats().get(), 0, 0);
        this.renderHearts(graphics, 0, 10, 5, 20.0f, currentHealth, 0);
        this.renderFood(graphics, shellEntry.stats().get(), 0, 20);
        pose.popPose();
    }

    @Override
    public Component getTitle(ShellBundle.ShellEntry entry) {
        return Component.literal((String)entry.title());
    }

    @Override
    public List<ShellBundle.ShellEntry> getEntries() {
        return this.displayedShell == null ? List.of() : this.displayedShell.getEntries();
    }

    @Nullable
    public ShellBundle getDisplayedShell() {
        return this.displayedShell;
    }

    @Override
    @Nullable
    public ShellEntity getPlayerShell(ShellBundle.ShellEntry entry) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || entry.shellUuid().isEmpty()) {
            return null;
        }
        UUID playerUuid = mc.player.getUUID();
        UUID shellUuid = entry.shellUuid().get();
        if (playerUuid.equals(MathUtils.EMPTY_UUID) || shellUuid.equals(MathUtils.EMPTY_UUID)) {
            return null;
        }
        return ShellForgeBlockEntityRenderer.getPlayerShellFromCache(mc.level, playerUuid, shellUuid, SHELL_CACHE);
    }

    @Override
    public int getPlayerShellCreationProgress(ShellBundle.ShellEntry entry) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || entry.shellUuid().isEmpty()) {
            return 0;
        }
        ShellState shellState = ClientShellData.INSTANCE.get(player.getUUID(), entry.shellUuid().get());
        if (shellState == null) {
            return 0;
        }
        return shellState.shellCreationProgress();
    }

    public void keyPressed(int key) {
        if (key == Minecraft.getInstance().options.keyUp.getKey().getValue()) {
            this.cancel();
        }
    }

    public void mouseClick(double mouseX, double mouseY, int button, int action) {
        RadialMenuRenderer.MousePos diffFromCenter;
        double distanceFromCenter;
        if (action == 0) {
            return;
        }
        if (button == 2) {
            this.cancel();
        }
        if ((distanceFromCenter = Mth.length((double)(diffFromCenter = ShellSelectionOverlay.getDiffFromCenter(mouseX, mouseY)).x(), (double)diffFromCenter.y())) < 30.0 || distanceFromCenter > 130.0) {
            return;
        }
        int selectionIndex = this.getElementUnderMouse();
        if (button == 0) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            if (this.onSelectShell != null) {
                ShellBundle.ShellEntry shellEntry = this.getEntries().get(selectionIndex);
                if (this.getPlayerShellCreationProgress(shellEntry) != 100) {
                    return;
                }
                this.onSelectShell.accept(shellEntry);
            }
            this.close(true);
        }
    }

    private void renderSlotContent(GuiGraphics graphics, ItemStack stack, int x, int y, int imageWidth) {
        int seed = x + y * imageWidth;
        graphics.renderItem(stack, x, y, seed);
        graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
    }

    private void renderFood(GuiGraphics graphics, ShellBundle.StatEntry stats, int x, int y) {
        int foodLevel = stats.foodLevel();
        boolean hasHunger = stats.activeEffects().containsKey(MobEffects.HUNGER);
        ResourceLocation emptySprite = hasHunger ? Gui.FOOD_EMPTY_HUNGER_SPRITE : Gui.FOOD_EMPTY_SPRITE;
        ResourceLocation halfSprite = hasHunger ? Gui.FOOD_HALF_HUNGER_SPRITE : Gui.FOOD_HALF_SPRITE;
        ResourceLocation fullSprite = hasHunger ? Gui.FOOD_FULL_HUNGER_SPRITE : Gui.FOOD_FULL_SPRITE;
        RenderSystem.enableBlend();
        for (int i = 0; i < 10; ++i) {
            int foodIndex = i * 2 + 1;
            int posX = x + i * 8;
            graphics.blitSprite(emptySprite, posX, y, 9, 9);
            if (foodIndex < foodLevel) {
                graphics.blitSprite(fullSprite, posX, y, 9, 9);
                continue;
            }
            if (foodIndex != foodLevel) continue;
            graphics.blitSprite(halfSprite, posX, y, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    private void renderArmor(GuiGraphics guiGraphics, ShellBundle.StatEntry stats, int x, int y) {
        int armorValue = stats.armorValue();
        if (armorValue > 0) {
            RenderSystem.enableBlend();
            for (int i = 0; i < 10; ++i) {
                int armorIndex = i * 2 + 1;
                int posX = x + i * 8;
                if (armorIndex < armorValue) {
                    guiGraphics.blitSprite(Gui.ARMOR_FULL_SPRITE, posX, y, 9, 9);
                }
                if (armorIndex == armorValue) {
                    guiGraphics.blitSprite(Gui.ARMOR_HALF_SPRITE, posX, y, 9, 9);
                }
                if (armorIndex <= armorValue) continue;
                guiGraphics.blitSprite(Gui.ARMOR_EMPTY_SPRITE, posX, y, 9, 9);
            }
            RenderSystem.disableBlend();
        }
    }

    private void renderHearts(GuiGraphics guiGraphics, int x, int y, int height, float maxHealth, int currentHealth, int absorptionAmount) {
        Gui.HeartType heartType = Gui.HeartType.NORMAL;
        boolean hardcore = false;
        int maxHealthHalves = Mth.ceil((double)((double)maxHealth / 2.0));
        int absorptionHearts = Mth.ceil((double)((double)absorptionAmount / 2.0));
        int totalHearts = maxHealthHalves + absorptionHearts;
        int maxHealthFull = maxHealthHalves * 2;
        for (int heartIndex = totalHearts - 1; heartIndex >= 0; --heartIndex) {
            int absorptionHalfIndex;
            boolean isAbsorptionHeart;
            int row = heartIndex / 10;
            int column = heartIndex % 10;
            int posX = x + column * 8;
            int posY = y - row * height;
            this.renderHeart(guiGraphics, Gui.HeartType.CONTAINER, posX, posY, false, false, false);
            int halfIndex = heartIndex * 2;
            boolean bl = isAbsorptionHeart = heartIndex >= maxHealthHalves;
            if (isAbsorptionHeart && (absorptionHalfIndex = halfIndex - maxHealthFull) < absorptionAmount) {
                boolean isHalf = absorptionHalfIndex + 1 == absorptionAmount;
                this.renderHeart(guiGraphics, heartType == Gui.HeartType.WITHERED ? heartType : Gui.HeartType.ABSORBING, posX, posY, false, false, isHalf);
            }
            if (halfIndex >= currentHealth) continue;
            boolean isHalf = halfIndex + 1 == currentHealth;
            this.renderHeart(guiGraphics, heartType, posX, posY, false, false, isHalf);
        }
    }

    private void renderHeart(GuiGraphics guiGraphics, Gui.HeartType heartType, int x, int y, boolean hardcore, boolean halfHeart, boolean blinking) {
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(heartType.getSprite(hardcore, blinking, halfHeart), x, y, 9, 9);
        RenderSystem.disableBlend();
    }

    public void open(Player player, Consumer<ShellBundle.ShellEntry> onSelectShell, Runnable onClose) {
        ArrayList<ShellBundle.ShellEntry> shellEntries = new ArrayList<ShellBundle.ShellEntry>();
        for (ShellState shellState : ClientShellData.INSTANCE.getAll(player.getUUID())) {
            Inventory inventory = new Inventory(player);
            inventory.load(shellState.playerData().getList("Inventory", 10));
            ShellBundle.InventoryEntry inventoryEntry = new ShellBundle.InventoryEntry((NonNullList<ItemStack>)inventory.items, (NonNullList<ItemStack>)inventory.armor, (NonNullList<ItemStack>)inventory.offhand);
            FoodData foodData = new FoodData();
            foodData.readAdditionalSaveData(shellState.playerData());
            AttributeMap attributes = new AttributeMap(DefaultAttributes.getSupplier((EntityType)EntityType.PLAYER));
            attributes.load(shellState.playerData().getList("attributes", 10));
            HashMap activeEffects = Maps.newHashMap();
            ListTag effectsTag = shellState.playerData().getList("active_effects", 10);
            for (int i = 0; i < effectsTag.size(); ++i) {
                MobEffectInstance effectInstance = MobEffectInstance.load((CompoundTag)effectsTag.getCompound(i));
                if (effectInstance == null) continue;
                activeEffects.put(effectInstance.getEffect(), effectInstance);
            }
            ShellBundle.StatEntry statEntry = new ShellBundle.StatEntry(shellState.playerData().getFloat("Health"), Mth.floor((double)attributes.getValue(Attributes.ARMOR)), foodData.getFoodLevel(), activeEffects);
            shellEntries.add(new ShellBundle.ShellEntry(player.getName().getString(), Optional.of(shellState.shellForgePos()), Optional.of(inventoryEntry), Optional.of(statEntry), Optional.of(shellState.shellUUID())));
        }
        if (shellEntries.isEmpty()) {
            shellEntries.add(new ShellBundle.ShellEntry("", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        }
        this.displayedShell = new ShellBundle(player.getUUID(), shellEntries);
        this.onSelectShell = onSelectShell;
        this.onClose = onClose;
    }

    public boolean isOpened() {
        return this.displayedShell != null;
    }

    private void cancel() {
        if (this.onClose != null) {
            this.onClose.run();
        }
        this.close(true);
    }

    public void close(boolean grabMouse) {
        if (grabMouse) {
            Minecraft.getInstance().mouseHandler.grabMouse();
        }
        this.displayedShell = null;
        this.clearState();
    }
}

