/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui.widgets;

import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import java.util.Objects;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ProgressBarWidget
extends AbstractWidget {
    private static final ResourceLocation GREEN_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"widget/green_progress_bar");
    private static final ResourceLocation RED_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"widget/red_progress_bar");
    private static final ResourceLocation SPRITE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"widget/progress_bar_background");
    private final ShellForgeBlockEntity shellForge;
    private final IntSupplier progressSupplier;

    public ProgressBarWidget(int x, int y, int width, int height, ShellForgeBlockEntity shellForge, IntSupplier progressSupplier) {
        super(x, y, width, height, (Component)Component.empty());
        this.shellForge = shellForge;
        this.progressSupplier = progressSupplier;
        this.tick();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(SPRITE_BACKGROUND, 82, 18, 0, 0, this.getX() - 1, this.getY() - 1, 82, 18);
        Minecraft mc = Minecraft.getInstance();
        int progress = this.progressSupplier.getAsInt();
        int filledWidth = (int)((double)progress / 100.0 * (double)this.getWidth());
        graphics.blitSprite(this.shellForge.getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATING ? RED_SPRITE : GREEN_SPRITE, 80, 16, 0, 0, this.getX(), this.getY(), filledWidth, this.getHeight());
        String progressText = progress + "%";
        int x = this.getX() + (this.getWidth() - mc.font.width(progressText)) / 2;
        int n = this.getY();
        int n2 = this.getHeight();
        Objects.requireNonNull(mc.font);
        int y = n + (n2 - 9) / 2 + 1;
        graphics.drawString(mc.font, progressText, x, y, -1);
    }

    public void tick() {
        this.visible = this.shellForge.getShellState() == ShellForgeBlockEntity.ShellStates.CREATING || this.shellForge.getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATING;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    public void playDownSound(SoundManager handler) {
    }
}

