/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.utils;

import com.ultramega.playershells.utils.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class CameraHandler {
    private static final long PHASE1_MS = 700L;
    private static final long PHASE2_MS = 2000L;
    private static final long PITCH_MS = 400L;
    private static final double BLOCKS_UP = 400.0;
    @Nullable
    private static Vec3 startPosition;
    @Nullable
    private static Direction startFacing;
    @Nullable
    private static Vec3 endPosition;
    @Nullable
    private static Direction endFacing;
    @Nullable
    private static Runnable onFinished;
    private static boolean animating;
    private static boolean reversing;
    private static long animClockMs;
    private static long lastNowMs;
    @Nullable
    private static Vec3 p0Start;
    @Nullable
    private static Vec3 p1Forward;
    @Nullable
    private static Vec3 p2Up;
    @Nullable
    private static Vec3 endStepDir;
    private static float startYaw;
    private static float startMidYaw;
    private static float endYaw;
    private static float endMidYaw;

    public static void cameraTick(Camera camera) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof ReceivingLevelScreen) {
            return;
        }
        long now = System.currentTimeMillis();
        if (!animating) {
            CameraHandler.beginAnimation(camera, now);
        }
        if (animating) {
            if (lastNowMs < 0L) {
                lastNowMs = now;
            }
            if (!mc.isPaused()) {
                animClockMs += Math.max(0L, now - lastNowMs);
            }
            lastNowMs = now;
            camera.detached = true;
            CameraHandler.applyAnimation(camera, animClockMs);
        }
        camera.setRotation(camera.getYRot(), camera.getXRot(), 0.0f);
    }

    public static void setMovingAnimation(@Nullable BlockPos startPosition, @Nullable Direction startFacing, BlockPos endPosition, Direction endFacing, Runnable onFinished) {
        CameraHandler.startPosition = startPosition != null ? startPosition.getCenter().add(0.0, 0.2, 0.0) : null;
        CameraHandler.startFacing = startFacing;
        CameraHandler.endPosition = endPosition.getCenter().add(0.0, 0.2, 0.0);
        CameraHandler.endFacing = endFacing;
        CameraHandler.onFinished = onFinished;
    }

    public static void resetPosition() {
        startPosition = null;
        startFacing = null;
        endPosition = null;
        endFacing = null;
        onFinished = null;
        animating = false;
        reversing = false;
        animClockMs = 0L;
        lastNowMs = -1L;
        p0Start = null;
        p1Forward = null;
        p2Up = null;
        endStepDir = null;
    }

    public static boolean isCameraOutsideOfPlayer() {
        return startPosition != null && startFacing != null || endPosition != null && endFacing != null;
    }

    private static void beginAnimation(Camera camera, long now) {
        if (endPosition == null || endFacing == null) {
            return;
        }
        animating = true;
        reversing = false;
        animClockMs = 0L;
        lastNowMs = now;
        if (startFacing != null && startPosition != null) {
            p0Start = startPosition;
            Vec3 startStepDir = new Vec3((double)startFacing.getStepX(), (double)startFacing.getStepY(), (double)startFacing.getStepZ());
            p1Forward = p0Start.add(startStepDir);
            p2Up = p1Forward.add(0.0, 400.0, 0.0);
            startYaw = startFacing.toYRot();
            startMidYaw = Mth.wrapDegrees((float)(startYaw + 180.0f));
        } else {
            p1Forward = camera.getPosition();
            p2Up = p1Forward.add(0.0, 400.0, 0.0);
        }
        endStepDir = new Vec3((double)endFacing.getStepX(), (double)endFacing.getStepY(), (double)endFacing.getStepZ());
        endYaw = endFacing.toYRot();
        endMidYaw = Mth.wrapDegrees((float)(endYaw + 180.0f));
    }

    private static void applyAnimation(Camera camera, long elapsedMs) {
        if (p2Up == null) {
            return;
        }
        long elapsed = Math.max(0L, elapsedMs);
        long forwardTotal = 2700L;
        if (!reversing && p0Start != null && p1Forward != null) {
            if (elapsed <= 700L) {
                float t = (float)elapsed / 700.0f;
                Vec3 pos = MathUtils.lerpVec3(p0Start, p1Forward, t);
                float yaw = MathUtils.lerpAngle(startYaw, startMidYaw, t);
                camera.setPosition(pos);
                camera.setRotation(yaw, 0.0f, 0.0f);
            } else if (elapsed <= 2700L) {
                float pitch;
                long phase2Elapsed = elapsed - 700L;
                float tRise = (float)phase2Elapsed / 2000.0f;
                Vec3 pos = MathUtils.lerpVec3(p1Forward, p2Up, tRise);
                if (phase2Elapsed <= 400L) {
                    float tPitch = (float)phase2Elapsed / 400.0f;
                    pitch = Mth.lerp((float)tPitch, (float)0.0f, (float)90.0f);
                } else {
                    pitch = 90.0f;
                }
                camera.setPosition(pos);
                camera.setRotation(startMidYaw, pitch, 0.0f);
            } else {
                camera.setPosition(p2Up);
                camera.setRotation(startMidYaw, 90.0f, 0.0f);
                reversing = true;
                animClockMs = 0L;
                if (onFinished != null) {
                    onFinished.run();
                }
            }
            return;
        }
        if (endPosition == null || endFacing == null || endStepDir == null) {
            CameraHandler.resetPosition();
            return;
        }
        Vec3 e0End = endPosition;
        Vec3 e1Forward = e0End.add(endStepDir);
        if (elapsed <= 2000L) {
            float tDown = (float)elapsed / 2000.0f;
            Vec3 pos = MathUtils.lerpVec3(p2Up, e1Forward, tDown);
            camera.setPosition(pos);
            camera.setRotation(endMidYaw, 90.0f, 0.0f);
        } else if (elapsed <= 2700L) {
            float pitch;
            long phase1BackElapsed = elapsed - 2000L;
            float t = (float)phase1BackElapsed / 700.0f;
            Vec3 pos = MathUtils.lerpVec3(e1Forward, e0End, t);
            float yaw = MathUtils.lerpAngle(endMidYaw, endYaw, t);
            if (phase1BackElapsed <= 400L) {
                float tPitch = (float)phase1BackElapsed / 400.0f;
                pitch = Mth.lerp((float)tPitch, (float)90.0f, (float)0.0f);
            } else {
                pitch = 0.0f;
            }
            camera.setPosition(pos);
            camera.setRotation(yaw, pitch, 0.0f);
        } else {
            camera.setPosition(e0End);
            camera.setRotation(endYaw, 0.0f, 0.0f);
            CameraHandler.resetPosition();
        }
    }

    static {
        animating = false;
        reversing = false;
        animClockMs = 0L;
        lastNowMs = -1L;
    }
}

