/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.client.model;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public class ClothingModel {
    public static ArmorModelSet<LayerDefinition> createArmorLayerSet() {
        return ClothingModel.createArmorMeshSet(new CubeDeformation(0.25f)).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64));
    }

    public static ArmorModelSet<MeshDefinition> createArmorMeshSet(CubeDeformation cubeDeformation) {
        return ClothingModel.createArmorMeshSet(ClothingModel::createMesh, cubeDeformation);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.getChild("head").addOrReplaceChild("hat_rim", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -8.0f, -5.0f, 16.0f, 16.0f, 0.0f, CubeDeformation.NONE), PartPose.rotation((float)-1.5707964f, (float)0.0f, (float)0.0f));
        return meshDefinition;
    }

    private static ArmorModelSet<MeshDefinition> createArmorMeshSet(Function<CubeDeformation, MeshDefinition> meshCreator, CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = meshCreator.apply(cubeDeformation);
        meshDefinition.getRoot().retainPartsAndChildren(Set.of("head"));
        MeshDefinition meshDefinition2 = meshCreator.apply(cubeDeformation);
        meshDefinition2.getRoot().retainExactParts(Set.of("body", "left_arm", "right_arm"));
        MeshDefinition meshDefinition3 = meshCreator.apply(cubeDeformation);
        meshDefinition3.getRoot().retainExactParts(Set.of("left_leg", "right_leg"));
        MeshDefinition meshDefinition4 = meshCreator.apply(cubeDeformation);
        meshDefinition4.getRoot().clearRecursively();
        return new ArmorModelSet((Object)meshDefinition, (Object)meshDefinition2, (Object)meshDefinition3, (Object)meshDefinition4);
    }
}

