/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public abstract class HumanoidHatLayer<S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final A model;
    private final A modelBaby;
    private final EquipmentLayerRenderer equipmentRenderer;

    public HumanoidHatLayer(RenderLayerParent<S, M> renderer, A model, A modelBaby, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer);
        this.model = model;
        this.modelBaby = modelBaby;
        this.equipmentRenderer = equipmentRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        this.renderHat(poseStack, nodeCollector, ((HumanoidRenderState)renderState).headEquipment, EquipmentSlot.HEAD, packedLight, renderState);
    }

    protected void renderHat(PoseStack poseStack, SubmitNodeCollector nodeCollector, ItemStack item, EquipmentSlot slot, int packedLight, S renderState) {
        Equippable equippable = (Equippable)item.get(DataComponents.EQUIPPABLE);
        if (equippable != null && HumanoidArmorLayer.shouldRender((Equippable)equippable, (EquipmentSlot)slot)) {
            poseStack.pushPose();
            EquipmentClientInfo.LayerType layerType = this.getLayerType(slot);
            A model = this.getModel(renderState);
            ((HumanoidModel)this.getParentModel()).translateToHead(poseStack);
            this.equipmentRenderer.renderLayers(layerType, (ResourceKey)equippable.assetId().orElseThrow(), model, renderState, item, poseStack, nodeCollector, packedLight, ((HumanoidRenderState)renderState).outlineColor);
            poseStack.popPose();
        }
    }

    public final A getModel(S renderState) {
        return ((HumanoidRenderState)renderState).isBaby ? this.modelBaby : this.model;
    }

    protected abstract EquipmentClientInfo.LayerType getLayerType(EquipmentSlot var1);
}

