/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.handler;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.villagemasquerade.init.ModItems;
import fuzs.villagemasquerade.init.ModTags;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import net.minecraft.class_4051;
import net.minecraft.class_4135;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ClothingEquipmentHandler {
    static final List<class_1304> CLOTHING_EQUIPMENT_SLOTS = ImmutableList.of((Object)class_1304.field_6169, (Object)class_1304.field_6174, (Object)class_1304.field_6172);
    static final class_4051.class_10254 ENEMY_SELECTOR = (livingEntity, serverLevel) -> ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.ENEMY_CLOTHING_ITEM_TAG);

    public static EventResult onLivingDrops(class_1309 livingEntity, class_1282 damageSource, Collection<class_1542> itemDrops, boolean recentlyHit) {
        class_6880<class_1792> holder;
        class_1548 creeper;
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1548 && (creeper = (class_1548)class_12972).method_7008() && (holder = ClothingEquipmentHandler.getHeadItem(livingEntity)) != null) {
            livingEntity.method_5775((class_3218)livingEntity.method_37908(), new class_1799(holder));
            creeper.method_7002();
        }
        return EventResult.PASS;
    }

    @Nullable
    private static class_6880<class_1792> getHeadItem(class_1309 livingEntity) {
        if (livingEntity.method_5864().method_20210(class_3483.field_48287)) {
            return ModItems.ILLAGER_HEAD_ITEM;
        }
        if (livingEntity instanceof class_1646) {
            return ModItems.VILLAGER_HEAD_ITEM;
        }
        if (livingEntity instanceof class_1439) {
            return ModItems.IRON_GOLEM_HEAD_ITEM;
        }
        return null;
    }

    public static EventResult onEntityLoad(class_1297 entity, class_3218 serverLevel, boolean isNewlySpawned) {
        if (entity instanceof class_1439) {
            class_1439 ironGolem = (class_1439)entity;
            ironGolem.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)ironGolem, class_1657.class, 10, true, false, ENEMY_SELECTOR));
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            if (entity.method_5864().method_20210(class_3483.field_19168)) {
                for (class_4135 wrappedGoal : mob.field_6185.method_35115()) {
                    class_1352 class_13522 = wrappedGoal.method_19058();
                    if (!(class_13522 instanceof class_1400)) continue;
                    class_1400 goal = (class_1400)class_13522;
                    if (goal.field_6643 != class_1657.class) continue;
                    class_4051.class_10254 originalSelector = goal.field_6642.field_28405;
                    goal.field_6642.field_28405 = (livingEntity, serverLevelX) -> (originalSelector == null || originalSelector.method_18303(livingEntity, serverLevelX)) && !ENEMY_SELECTOR.method_18303(livingEntity, serverLevelX);
                }
            }
        }
        return EventResult.PASS;
    }

    public static void onLivingVisibility(class_1309 livingEntity, @Nullable class_1297 lookingEntity, MutableDouble visibilityPercentage) {
        if (lookingEntity instanceof class_1569 && lookingEntity.method_37908().method_23886() && ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.WANDERING_TRADER_CLOTHING_ITEM_TAG)) {
            visibilityPercentage.mapDouble(value -> value * 0.25);
        }
    }

    public static EventResult onMobEffectAffects(class_1309 livingEntity, class_1293 mobEffect) {
        if (ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.WITCH_CLOTHING_ITEM_TAG) && mobEffect.method_5579().method_40220(ModTags.WITCH_CLOTHING_RESISTANT_TO_MOB_EFFECT_TAG)) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static boolean isWearingOutfit(class_1309 livingEntity, class_6862<class_1792> tagKey) {
        for (class_1304 equipmentSlot : CLOTHING_EQUIPMENT_SLOTS) {
            if (livingEntity.method_6118(equipmentSlot).method_31573(tagKey)) continue;
            return false;
        }
        return true;
    }
}

