/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.villagemasquerade.client.model.ClothingModel;
import fuzs.villagemasquerade.client.model.geom.ModModelLayers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class HumanoidClothingLayer<S extends HumanoidRenderState, M extends HumanoidModel<S>, A extends ClothingModel<S>>
extends HumanoidArmorLayer<S, M, A> {
    public HumanoidClothingLayer(RenderLayerParent<S, M> renderer, A model, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer, model, model, equipmentRenderer);
    }

    public HumanoidClothingLayer(RenderLayerParent<S, M> renderer, A model, A modelBaby, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer, model, model, modelBaby, modelBaby, equipmentRenderer);
    }

    protected void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack armorItem, EquipmentSlot slot, int packedLight, A model) {
        Equippable equippable = (Equippable)armorItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && HumanoidClothingLayer.shouldRender((Equippable)equippable, (EquipmentSlot)slot)) {
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            this.setPartVisibility(model, slot);
            this.equipmentRenderer.renderLayers(ModModelLayers.CLOTHING_LAYER_TYPE, (ResourceKey)equippable.assetId().orElseThrow(), model, armorItem, poseStack, bufferSource, packedLight);
        }
    }

    protected void setPartVisibility(A model, EquipmentSlot slot) {
        ((ClothingModel)((Object)model)).setAllVisible(false);
        switch (slot) {
            case HEAD: {
                ((ClothingModel)((Object)model)).head.visible = true;
                ((ClothingModel)((Object)model)).hat.visible = true;
                ((ClothingModel)((Object)model)).hatRim.visible = true;
                break;
            }
            case CHEST: {
                ((ClothingModel)((Object)model)).body.visible = true;
                ((ClothingModel)((Object)model)).rightArm.visible = true;
                ((ClothingModel)((Object)model)).leftArm.visible = true;
                break;
            }
            case LEGS: 
            case FEET: {
                ((ClothingModel)((Object)model)).rightLeg.visible = true;
                ((ClothingModel)((Object)model)).leftLeg.visible = true;
            }
        }
    }
}

