/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade.handler;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.villagemasquerade.init.ModItems;
import fuzs.villagemasquerade.init.ModTags;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClothingEquipmentHandler {
    static final List<EquipmentSlot> CLOTHING_EQUIPMENT_SLOTS = ImmutableList.of((Object)EquipmentSlot.HEAD, (Object)EquipmentSlot.CHEST, (Object)EquipmentSlot.LEGS);
    static final TargetingConditions.Selector ENEMY_SELECTOR = (livingEntity, serverLevel) -> ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.ENEMY_CLOTHING_ITEM_TAG);

    public static EventResult onLivingDrops(LivingEntity livingEntity, DamageSource damageSource, Collection<ItemEntity> itemDrops, boolean recentlyHit) {
        Object item;
        Creeper creeper;
        Entity entity = damageSource.getEntity();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).canDropMobsSkull() && (item = livingEntity.getType().is(EntityTypeTags.ILLAGER) ? ModItems.ILLAGER_HEAD_ITEM : (livingEntity instanceof Villager ? ModItems.VILLAGER_HEAD_ITEM : (livingEntity instanceof IronGolem ? ModItems.IRON_GOLEM_HEAD_ITEM : null))) != null) {
            livingEntity.spawnAtLocation((ServerLevel)livingEntity.level(), new ItemStack(item));
            creeper.increaseDroppedSkulls();
        }
        return EventResult.PASS;
    }

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel) {
        if (entity instanceof IronGolem) {
            IronGolem ironGolem = (IronGolem)entity;
            ironGolem.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)ironGolem, Player.class, 10, true, false, ENEMY_SELECTOR));
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (entity.getType().is(EntityTypeTags.RAIDERS)) {
                for (WrappedGoal wrappedGoal : mob.targetSelector.getAvailableGoals()) {
                    Goal goal = wrappedGoal.getGoal();
                    if (!(goal instanceof NearestAttackableTargetGoal)) continue;
                    NearestAttackableTargetGoal goal2 = (NearestAttackableTargetGoal)goal;
                    if (goal2.targetType != Player.class) continue;
                    TargetingConditions.Selector originalSelector = goal2.targetConditions.selector;
                    goal2.targetConditions.selector = (livingEntity, serverLevelX) -> (originalSelector == null || originalSelector.test(livingEntity, serverLevelX)) && !ENEMY_SELECTOR.test(livingEntity, serverLevelX);
                }
            }
        }
        return EventResult.PASS;
    }

    public static void onLivingVisibility(LivingEntity livingEntity, @Nullable Entity lookingEntity, MutableDouble visibilityPercentage) {
        if (lookingEntity instanceof Enemy && lookingEntity.level().isDarkOutside() && ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.WANDERING_TRADER_CLOTHING_ITEM_TAG)) {
            visibilityPercentage.mapDouble(value -> value * 0.25);
        }
    }

    public static EventResult onMobEffectAffects(LivingEntity livingEntity, MobEffectInstance mobEffect) {
        if (ClothingEquipmentHandler.isWearingOutfit(livingEntity, ModTags.WITCH_CLOTHING_ITEM_TAG) && mobEffect.getEffect().is(ModTags.WITCH_CLOTHING_RESISTANT_TO_MOB_EFFECT_TAG)) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static boolean isWearingOutfit(LivingEntity livingEntity, TagKey<Item> tagKey) {
        for (EquipmentSlot equipmentSlot : CLOTHING_EQUIPMENT_SLOTS) {
            if (livingEntity.getItemBySlot(equipmentSlot).is(tagKey)) continue;
            return false;
        }
        return true;
    }
}

