/*
 * Decompiled with CFR 0.152.
 */
package fuzs.villagemasquerade;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.villagemasquerade.VillagerTradesContext;
import fuzs.villagemasquerade.handler.ClothingEquipmentHandler;
import fuzs.villagemasquerade.init.ModBlocks;
import fuzs.villagemasquerade.init.ModItems;
import fuzs.villagemasquerade.init.ModLootTables;
import fuzs.villagemasquerade.init.ModRegistry;
import fuzs.villagemasquerade.util.VillagerTradingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillageMasquerade
implements ModConstructor {
    public static final String MOD_ID = "villagemasquerade";
    public static final String MOD_NAME = "Village Masquerade";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Village Masquerade");

    public void onConstructMod() {
        ModRegistry.bootstrap();
        VillageMasquerade.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        AddBlockEntityTypeBlocksCallback.EVENT.register(ModBlocks::onAddBlockEntityTypeBlocks);
        LivingDropsCallback.EVENT.register(ClothingEquipmentHandler::onLivingDrops);
        LootTableLoadCallback.EVENT.register(ModLootTables::onLootTableLoad);
        ServerEntityLevelEvents.LOAD.register(ClothingEquipmentHandler::onEntityLoad);
        MobEffectEvents.AFFECTS.register(ClothingEquipmentHandler::onMobEffectAffects);
        LivingVisibilityCallback.EVENT.register(ClothingEquipmentHandler::onLivingVisibility);
    }

    public void onRegisterVillagerTrades(VillagerTradesContext context) {
        class_7923.field_41178.method_42017().filter(holder -> holder.method_40237().method_29177().method_12836().equals(MOD_ID)).map(class_6880.class_6883::comp_349).forEach(item -> {
            class_5321 resourceKey = (class_5321)item.method_57347().method_58695((class_9331)ModRegistry.VILLAGER_PROFESSION_DATA_COMPONENT_TYPE.comp_349(), (Object)class_3852.field_17051);
            if (resourceKey != class_3852.field_17051) {
                context.registerVillagerTrades((class_5321<class_3852>)resourceKey, VillagerTradesContext.VillagerLevel.MASTER, itemListings -> itemListings.add(VillagerTradingHelper.createVillagerItemListing(item)));
            }
        });
        context.registerWanderingTrades(VillagerTradesContext.WanderingTradesPool.SPECIAL_SALES, VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_HOOD_ITEM), VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_ROBE_ITEM), VillagerTradingHelper.createWanderingItemListing(ModItems.WANDERING_TRADER_LEGGINGS_ITEM));
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

