/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight.apparatus;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.flight.apparatus.WingFormRegistry;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class WingForm<A extends Animator<S>, S> {
    private final ResourceKey<FlightApparatus> resourceKey;
    private final Supplier<A> animator;
    private final Supplier<S> state;
    private final Supplier<WingsModel<S>> model;
    private final ResourceLocation textureLocation;

    public WingForm(ResourceKey<FlightApparatus> resourceKey, Supplier<A> animator, Supplier<S> state, Supplier<WingsModel<S>> model) {
        this.resourceKey = resourceKey;
        this.animator = animator;
        this.state = state;
        this.model = model;
        this.textureLocation = FlightApparatus.transformTextureLocation(FlightApparatus.getTextureLocation(resourceKey));
    }

    public A createAnimator() {
        return (A)((Animator)this.animator.get());
    }

    public S createRenderState() {
        return this.state.get();
    }

    public WingsModel<S> getModel() {
        return this.model.get();
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof WingForm)) return false;
        WingForm wingForm = (WingForm)obj;
        if (wingForm.resourceKey != this.resourceKey) return false;
        return true;
    }

    public static Optional<WingForm<?, ?>> get(Holder<FlightApparatus> holder) {
        return Optional.of(WingFormRegistry.INSTANCE.createWings(holder));
    }

    public record FormRendererState<S>(FormRenderer<S> form, S state) {
        public void submitModel(PoseStack poseStack, SubmitNodeCollector nodeCollector, Function<ResourceLocation, RenderType> renderTypeGetter, int packedLight, int outlineColor) {
            this.form.submitModel(this.state, poseStack, nodeCollector, renderTypeGetter.apply(this.form.getTextureLocation()), packedLight, outlineColor);
        }
    }

    public static interface FormRenderer<S> {
        public ResourceLocation getTextureLocation();

        public S createRenderState(float var1);

        default public FormRendererState<S> pack(float partialTick) {
            return new FormRendererState<S>(this, this.createRenderState(partialTick));
        }

        public void submitModel(S var1, PoseStack var2, SubmitNodeCollector var3, RenderType var4, int var5, int var6);
    }
}

