/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight.apparatus;

import fuzs.fantasticwings.client.animator.AnimatorAvian;
import fuzs.fantasticwings.client.animator.AnimatorInsectoid;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.model.AvianWingsModel;
import fuzs.fantasticwings.client.model.InsectoidWingsModel;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.client.model.geom.ModModelLayers;
import fuzs.fantasticwings.client.renderer.entity.state.AvianRenderState;
import fuzs.fantasticwings.client.renderer.entity.state.InsectoidRenderState;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public final class WingFormRegistry
implements ResourceManagerReloadListener {
    public static final WingFormRegistry INSTANCE = new WingFormRegistry();
    private WingsModel<AvianRenderState> avianWings;
    private WingsModel<InsectoidRenderState> insectoidWings;

    private WingFormRegistry() {
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        EntityModelSet entityModels = Minecraft.getInstance().getEntityModels();
        this.avianWings = new AvianWingsModel(entityModels.bakeLayer(ModModelLayers.AVIAN_WINGS_MODEL_LAYER));
        this.insectoidWings = new InsectoidWingsModel(entityModels.bakeLayer(ModModelLayers.INSECTOID_WINGS_MODEL_LAYER));
    }

    public WingForm<?, ?> createWings(Holder<FlightApparatus> holder) {
        ResourceKey resourceKey = (ResourceKey)holder.unwrapKey().orElseThrow();
        return switch (((FlightApparatus)holder.value()).model()) {
            default -> throw new MatchException(null, null);
            case FlightApparatus.Model.AVIAN -> new WingForm<AnimatorAvian, AvianRenderState>((ResourceKey<FlightApparatus>)resourceKey, AnimatorAvian::new, AvianRenderState::new, () -> this.avianWings);
            case FlightApparatus.Model.INSECTOID -> new WingForm<AnimatorInsectoid, InsectoidRenderState>((ResourceKey<FlightApparatus>)resourceKey, AnimatorInsectoid::new, InsectoidRenderState::new, () -> this.insectoidWings);
        };
    }
}

