/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightView;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.Flight;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;

public class ClientEventHandler {
    public static final ContextKey<Optional<WingForm.FormRendererState<?>>> WING_FORM_KEY = new ContextKey(FantasticWings.id("wing_form"));
    public static final ContextKey<Float> FLYING_AMOUNT_KEY = new ContextKey(FantasticWings.id("flying_amount"));
    public static final ContextKey<Float> ROLL_KEY = new ContextKey(FantasticWings.id("roll"));
    public static final ContextKey<Float> PITCH_KEY = new ContextKey(FantasticWings.id("pitch"));

    public static void setupPlayerAnim(AvatarRenderState renderState, HumanoidModel<AvatarRenderState> model) {
        float flyingAmount = ((Float)RenderStateExtraData.getOrDefault((EntityRenderState)renderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount != 0.0f) {
            model.head.xRot = MathHelper.toRadians(MathHelper.lerp(renderState.xRot, renderState.xRot / 4.0f - 90.0f, flyingAmount));
            model.leftArm.xRot = MathHelper.lerp(model.leftArm.xRot, -3.2f, flyingAmount);
            model.rightArm.xRot = MathHelper.lerp(model.rightArm.xRot, -3.2f, flyingAmount);
            model.leftLeg.xRot = MathHelper.lerp(model.leftLeg.xRot, 0.0f, flyingAmount);
            model.rightLeg.xRot = MathHelper.lerp(model.rightLeg.xRot, 0.0f, flyingAmount);
        }
    }

    public static void setupPlayerRotations(AvatarRenderState renderState, PoseStack poseStack) {
        float flyingAmount = ((Float)RenderStateExtraData.getOrDefault((EntityRenderState)renderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount > 0.0f) {
            float roll = ((Float)RenderStateExtraData.getOrDefault((EntityRenderState)renderState, ROLL_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            float pitch = ((Float)RenderStateExtraData.getOrDefault((EntityRenderState)renderState, PITCH_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(MathHelper.lerpDegrees(0.0f, roll, flyingAmount)));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(MathHelper.lerpDegrees(0.0f, pitch, flyingAmount)));
            poseStack.translate(0.0, -1.2 * (double)MathHelper.easeInOut(flyingAmount), 0.0);
        }
    }

    public static void onComputeCameraAngles(GameRenderer renderer, Camera camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.getOrDefault((Object)camera.getEntity(), (Object)Flight.VOID);
        float flyingAmount = flight.getFlyingAmount(partialTick);
        if (flyingAmount > 0.0f) {
            Player player = (Player)camera.getEntity();
            float newRoll = MathHelper.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), partialTick);
            roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
        }
    }

    public static EventResult onEntityLoad(Entity entity, ClientLevel level) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)localPlayer);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new WingsSound((Player)localPlayer, flight));
        }
        return EventResult.PASS;
    }

    public static void onExtractRenderState(Entity entity, EntityRenderState entityRenderState, float partialTick) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            if (entityRenderState instanceof AvatarRenderState) {
                AvatarRenderState playerRenderState = (AvatarRenderState)entityRenderState;
                FlightView flightView = (FlightView)ClientModRegistry.FLIGHT_VIEW_ATTACHMENT_TYPE.getOrDefault((Object)entity, (Object)FlightView.VOID);
                flightView.ifFormPresent(form -> RenderStateExtraData.set((EntityRenderState)entityRenderState, WING_FORM_KEY, Optional.of(form.pack(partialTick))));
                RenderStateExtraData.set((EntityRenderState)entityRenderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.getOrDefault((Object)player, (Object)Flight.VOID)).getFlyingAmount(partialTick)));
                float roll = MathHelper.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), partialTick);
                RenderStateExtraData.set((EntityRenderState)entityRenderState, ROLL_KEY, (Object)Float.valueOf(roll));
                float pitch = -MathHelper.lerpDegrees(player.xRotO, player.getXRot(), partialTick) - 90.0f;
                RenderStateExtraData.set((EntityRenderState)entityRenderState, PITCH_KEY, (Object)Float.valueOf(pitch));
                if (ClientEventHandler.mustPreventCrouchingOffset((Player)player)) {
                    playerRenderState.isCrouching = false;
                }
            }
        }
    }

    private static boolean mustPreventCrouchingOffset(Player player) {
        if (player.isCrouching()) {
            Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)player);
            return flight.isFlying() || !flight.isEmpty() && player.getDeltaMovement().y() < -0.5;
        }
        return false;
    }

    public static EventResult onRenderOffHand(ItemInHandRenderer itemInHandRenderer, InteractionHand interactionHand, AbstractClientPlayer player, HumanoidArm humanoidArm, ItemStack itemStack, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.isEmpty() && !player.isScoping() && !player.isInvisible() && !itemInHandRenderer.mainHandItem.is(Items.FILLED_MAP) && ((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)player)).isFlying()) {
            itemInHandRenderer.renderPlayerArm(poseStack, submitNodeCollector, combinedLight, equipProgress, swingProgress, player.getMainArm().getOpposite());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(Entity entity, float deltaYaw) {
        float theta;
        Player player;
        if (entity instanceof Player && ((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)(player = (Player)entity))).isFlying() && ((theta = Mth.wrapDegrees((float)(player.getYRot() - player.yBodyRot))) < -50.0f || theta > 50.0f)) {
            player.yBodyRot += deltaYaw;
            player.yBodyRotO += deltaYaw;
        }
    }
}

