/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.client.model.geom.builders.FlatCubeListBuilder;
import fuzs.fantasticwings.client.renderer.entity.state.AvianRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.phys.Vec3;

public final class AvianWingsModel
extends WingsModel<AvianRenderState> {
    public static final int BONES = 4;
    public static final int FEATHERS = 4;
    private final ImmutableList<ModelPart> bonesLeft;
    private final ImmutableList<ModelPart> bonesRight;
    private final ImmutableList<ModelPart> feathersLeft;
    private final ImmutableList<ModelPart> feathersRight;

    public AvianWingsModel(ModelPart modelPart) {
        super(modelPart);
        ModelPart leftCoracoid = modelPart.getChild("left_coracoid");
        ModelPart rightCoracoid = modelPart.getChild("right_coracoid");
        ModelPart leftHumerus = leftCoracoid.getChild("left_humerus");
        ModelPart rightHumerus = rightCoracoid.getChild("right_humerus");
        ModelPart leftUlna = leftHumerus.getChild("left_ulna");
        ModelPart rightUlna = rightHumerus.getChild("right_ulna");
        ModelPart leftCarpals = leftUlna.getChild("left_carpals");
        ModelPart rightCarpals = rightUlna.getChild("right_carpals");
        ModelPart leftCoracoidFeathers = leftCoracoid.getChild("left_coracoid_feathers");
        ModelPart rightCoracoidFeathers = rightCoracoid.getChild("right_coracoid_feathers");
        ModelPart leftTertiaryFeathers = leftHumerus.getChild("left_tertiary_feathers");
        ModelPart rightTertiaryFeathers = rightHumerus.getChild("right_tertiary_feathers");
        ModelPart leftSecondaryFeathers = leftUlna.getChild("left_secondary_feathers");
        ModelPart rightSecondaryFeathers = rightUlna.getChild("right_secondary_feathers");
        ModelPart leftPrimaryFeathers = leftCarpals.getChild("left_primary_feathers");
        ModelPart rightPrimaryFeathers = rightCarpals.getChild("right_primary_feathers");
        this.bonesLeft = ImmutableList.of((Object)leftCoracoid, (Object)leftHumerus, (Object)leftUlna, (Object)leftCarpals);
        this.bonesRight = ImmutableList.of((Object)rightCoracoid, (Object)rightHumerus, (Object)rightUlna, (Object)rightCarpals);
        this.feathersLeft = ImmutableList.of((Object)leftCoracoidFeathers, (Object)leftTertiaryFeathers, (Object)leftSecondaryFeathers, (Object)leftPrimaryFeathers);
        this.feathersRight = ImmutableList.of((Object)rightCoracoidFeathers, (Object)rightTertiaryFeathers, (Object)rightSecondaryFeathers, (Object)rightPrimaryFeathers);
        Preconditions.checkState((this.bonesLeft.size() == 4 && this.bonesRight.size() == 4 ? 1 : 0) != 0);
        Preconditions.checkState((this.feathersLeft.size() == 4 && this.feathersRight.size() == 4 ? 1 : 0) != 0);
    }

    public static LayerDefinition createWingsLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        PartDefinition leftCoracoid = root.addOrReplaceChild("left_coracoid", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offset((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition rightCoracoid = root.addOrReplaceChild("right_coracoid", CubeListBuilder.create().texOffs(0, 34).addBox(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition leftHumerus = leftCoracoid.addOrReplaceChild("left_humerus", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.offset((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition rightHumerus = rightCoracoid.addOrReplaceChild("right_humerus", CubeListBuilder.create().texOffs(0, 7).addBox(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.offset((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition leftUlna = leftHumerus.addOrReplaceChild("left_ulna", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.offset((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition rightUlna = rightHumerus.addOrReplaceChild("right_ulna", CubeListBuilder.create().texOffs(22, 6).addBox(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.offset((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition leftCarpals = leftUlna.addOrReplaceChild("left_carpals", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offset((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightCarpals = rightUlna.addOrReplaceChild("right_carpals", CubeListBuilder.create().texOffs(46, 4).addBox(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offset((float)-8.5f, (float)0.0f, (float)0.0f));
        leftCoracoid.addOrReplaceChild("left_coracoid_feathers", FlatCubeListBuilder.create().texOffs(6, 40).addBox(0.0f, 0.0f, -1.0f, 6.0f, 8.0f, 1.0f), PartPose.offset((float)0.4f, (float)0.0f, (float)1.0f));
        rightCoracoid.addOrReplaceChild("right_coracoid_feathers", FlatCubeListBuilder.create().texOffs(0, 40).addBox(-6.0f, 0.0f, -1.0f, 6.0f, 8.0f, 1.0f), PartPose.offset((float)-0.4f, (float)0.0f, (float)1.0f));
        leftHumerus.addOrReplaceChild("left_tertiary_feathers", FlatCubeListBuilder.create().texOffs(10, 14).addBox(0.0f, 0.0f, -0.5f, 10.0f, 14.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        rightHumerus.addOrReplaceChild("right_tertiary_feathers", FlatCubeListBuilder.create().texOffs(0, 14).addBox(-10.0f, 0.0f, -0.5f, 10.0f, 14.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        leftUlna.addOrReplaceChild("left_secondary_feathers", FlatCubeListBuilder.create().texOffs(31, 14).addBox(-2.0f, 0.0f, -0.5f, 11.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        rightUlna.addOrReplaceChild("right_secondary_feathers", FlatCubeListBuilder.create().texOffs(20, 14).addBox(-9.0f, 0.0f, -0.5f, 11.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        leftCarpals.addOrReplaceChild("left_primary_feathers", FlatCubeListBuilder.create().texOffs(53, 14).addBox(0.0f, -2.1f, -0.5f, 11.0f, 11.0f, 1.0f), PartPose.ZERO);
        rightCarpals.addOrReplaceChild("right_primary_feathers", FlatCubeListBuilder.create().texOffs(42, 14).addBox(-11.0f, -2.1f, -0.5f, 11.0f, 11.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(AvianRenderState renderState) {
        ModelPart right;
        ModelPart left;
        int i;
        super.setupAnim((Object)renderState);
        for (i = 0; i < 4; ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            AvianWingsModel.setAngles(left, right, (Vec3)renderState.wingAngles.getOrDefault(i, (Object)Vec3.ZERO));
        }
        for (i = 0; i < 4; ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            AvianWingsModel.setAngles(left, right, (Vec3)renderState.featherAngles.getOrDefault(i, (Object)Vec3.ZERO));
        }
    }
}

