/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.client.renderer.entity.state.InsectoidRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class InsectoidWingsModel
extends WingsModel<InsectoidRenderState> {
    private final ModelPart wingLeft;
    private final ModelPart wingRight;

    public InsectoidWingsModel(ModelPart modelPart) {
        super(modelPart);
        this.wingLeft = modelPart.getChild("left_wing");
        this.wingRight = modelPart.getChild("right_wing");
    }

    public static LayerDefinition createWingsLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -8.0f, 0.0f, 19.0f, 24.0f, 0.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)2.5f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 24).addBox(-19.0f, -8.0f, 0.0f, 19.0f, 24.0f, 0.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)2.5f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(InsectoidRenderState renderState) {
        super.setupAnim((Object)renderState);
        InsectoidWingsModel.setAngles(this.wingLeft, this.wingRight, renderState.angles);
    }
}

