/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model.geom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.services.ClientAbstractions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class FlatModelPartCube
extends ModelPart.Cube {
    public FlatModelPartCube(float texCoordU, float texCoordV, float originX, float originY, float originZ, float dimensionX, float dimensionY, float dimensionZ, float growX, float growY, float growZ, boolean mirror, float texScaleU, float texScaleV, Set<Direction> visibleFaces) {
        this(texCoordU, texCoordV, texCoordU + dimensionX, texCoordV + dimensionY, originX, originY, originZ, dimensionX, dimensionY, dimensionZ, growX, growY, growZ, mirror, texScaleU, texScaleV, visibleFaces);
    }

    private FlatModelPartCube(float u1, float v1, float u2, float v2, float originX, float originY, float originZ, float dimensionX, float dimensionY, float dimensionZ, float growX, float growY, float growZ, boolean mirror, float texScaleU, float texScaleV, Set<Direction> visibleFaces) {
        super((int)u1, (int)v1, originX, originY, originZ, dimensionX, dimensionY, dimensionZ, growX, growY, growZ, mirror, texScaleU, texScaleV, EnumSet.noneOf(Direction.class));
        float v;
        float y;
        float u;
        float x;
        int i;
        float x0 = this.minX - growX;
        float x1 = this.maxX + growX;
        float y0 = this.minY - growY;
        float y1 = this.maxY + growY;
        float z0 = this.minZ - growZ;
        float z1 = this.maxZ + growZ;
        float stepX = (x1 - x0) / dimensionX;
        float stepY = (y1 - y0) / dimensionY;
        this.polygons = new ModelPart.Polygon[FlatModelPartCube.calculatePolygonCount(visibleFaces, (int)dimensionX, (int)dimensionY)];
        int polygonIndex = 0;
        if (visibleFaces.contains(Direction.NORTH)) {
            this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x0, y0, z0, x1, y1, z0, Direction.NORTH), u1, v1, u2, v2, texScaleU, texScaleV, false, Direction.NORTH);
        }
        if (visibleFaces.contains(Direction.SOUTH)) {
            this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x0, y1, z1, x1, y0, z1, Direction.SOUTH), u1, v2, u2, v1, texScaleU, texScaleV, false, Direction.SOUTH);
        }
        if (visibleFaces.contains(Direction.WEST)) {
            i = 0;
            while ((float)i < dimensionX) {
                x = x0 + (float)i * stepX;
                u = Mth.lerp((float)((float)i / dimensionX), (float)u1, (float)u2) + 0.5f;
                this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x, y0, z0, x, y1, z1, Direction.WEST), u, v1, u, v2, texScaleU, texScaleV, false, Direction.WEST);
                ++i;
            }
        }
        if (visibleFaces.contains(Direction.EAST)) {
            i = 0;
            while ((float)i < dimensionX) {
                x = x0 + (float)(i + 1) * stepX;
                u = Mth.lerp((float)((float)i / dimensionX), (float)u1, (float)u2) + 0.5f;
                this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x, y1, z0, x, y0, z1, Direction.EAST), u, v2, u, v1, texScaleU, texScaleV, false, Direction.EAST);
                ++i;
            }
        }
        if (visibleFaces.contains(Direction.UP)) {
            i = 0;
            while ((float)i < dimensionY) {
                y = y0 + (float)(i + 1) * stepY;
                v = Mth.lerp((float)((float)i / dimensionY), (float)v1, (float)v2) + 0.5f;
                this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x0, y, z0, x1, y, z1, Direction.UP), u1, v, u2, v, texScaleU, texScaleV, false, Direction.UP);
                ++i;
            }
        }
        if (visibleFaces.contains(Direction.DOWN)) {
            i = 0;
            while ((float)i < dimensionY) {
                y = y0 + (float)i * stepY;
                v = Mth.lerp((float)((float)i / dimensionY), (float)v1, (float)v2) + 0.5f;
                this.polygons[polygonIndex++] = new ModelPart.Polygon(FlatModelPartCube.createVertices(x1, y, z0, x0, y, z1, Direction.DOWN), u2, v, u1, v, texScaleU, texScaleV, false, Direction.DOWN);
                ++i;
            }
        }
    }

    public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        if (ModLoaderEnvironment.INSTANCE.isModLoaded("sodium")) {
            vertexConsumer = ClientAbstractions.INSTANCE.createVertexConsumer(vertexConsumer);
        }
        super.compile(pose, vertexConsumer, packedLight, packedOverlay, color);
    }

    private static int calculatePolygonCount(Set<Direction> visibleFaces, int dimensionX, int dimensionY) {
        int polygonCount = 0;
        if (visibleFaces.contains(Direction.NORTH)) {
            ++polygonCount;
        }
        if (visibleFaces.contains(Direction.SOUTH)) {
            ++polygonCount;
        }
        if (visibleFaces.contains(Direction.WEST)) {
            polygonCount += dimensionX;
        }
        if (visibleFaces.contains(Direction.EAST)) {
            polygonCount += dimensionX;
        }
        if (visibleFaces.contains(Direction.UP)) {
            polygonCount += dimensionY;
        }
        if (visibleFaces.contains(Direction.DOWN)) {
            polygonCount += dimensionY;
        }
        return polygonCount;
    }

    private static ModelPart.Vertex[] createVertices(float x0, float y0, float z0, float x1, float y1, float z1, Direction direction) {
        ModelPart.Vertex[] vertices = new ModelPart.Vertex[4];
        boolean isVertical = direction.getAxis().isVertical();
        vertices[0] = new ModelPart.Vertex(x1, y0, z0, 0.0f, 0.0f);
        vertices[1] = new ModelPart.Vertex(x0, y0, isVertical ? z0 : z1, 0.0f, 0.0f);
        vertices[2] = new ModelPart.Vertex(x0, y1, z1, 0.0f, 0.0f);
        vertices[3] = new ModelPart.Vertex(x1, y1, isVertical ? z1 : z0, 0.0f, 0.0f);
        return vertices;
    }
}

