/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.world.item.consume_effects;

import com.mojang.serialization.MapCodec;
import fuzs.fantasticwings.flight.Flight;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;

public record GrantWingsConsumeEffect(Holder<FlightApparatus> holder) implements ConsumeEffect
{
    public static final MapCodec<GrantWingsConsumeEffect> CODEC = FlightApparatus.CODEC.fieldOf("wings").xmap(GrantWingsConsumeEffect::new, GrantWingsConsumeEffect::holder);
    public static final StreamCodec<RegistryFriendlyByteBuf, GrantWingsConsumeEffect> STREAM_CODEC = FlightApparatus.STREAM_CODEC.map(GrantWingsConsumeEffect::new, GrantWingsConsumeEffect::holder);

    public ConsumeEffect.Type<? extends ConsumeEffect> getType() {
        return (ConsumeEffect.Type)ModRegistry.GRANT_WINGS_CONSUME_EFFECT_TYPE.value();
    }

    public boolean apply(Level level, ItemStack stack, LivingEntity entity) {
        ServerPlayer serverPlayer;
        return entity instanceof ServerPlayer && GrantWingsConsumeEffect.giveWings(serverPlayer = (ServerPlayer)entity, this.holder);
    }

    public static boolean giveWings(ServerPlayer serverPlayer, Holder<FlightApparatus> flightApparatus) {
        Flight newFlight;
        Flight oldFlight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)serverPlayer);
        if (!Objects.equals(oldFlight, newFlight = oldFlight.setWings(flightApparatus))) {
            ModRegistry.FLIGHT_ATTACHMENT_TYPE.set((Object)serverPlayer, (Object)newFlight);
            serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)ModRegistry.ITEM_ARMOR_EQUIP_WINGS.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

