/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight.apparatus;

import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.flight.apparatus.WingFormRegistry;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public final class WingForm<A extends Animator<S>, S> {
    private final class_5321<FlightApparatus> resourceKey;
    private final Supplier<A> animator;
    private final Supplier<S> state;
    private final Supplier<WingsModel<S>> model;
    private final class_2960 textureLocation;

    public WingForm(class_5321<FlightApparatus> resourceKey, Supplier<A> animator, Supplier<S> state, Supplier<WingsModel<S>> model) {
        this.resourceKey = resourceKey;
        this.animator = animator;
        this.state = state;
        this.model = model;
        this.textureLocation = FlightApparatus.transformTextureLocation(FlightApparatus.getTextureLocation(resourceKey));
    }

    public A createAnimator() {
        return (A)((Animator)this.animator.get());
    }

    public S createRenderState() {
        return this.state.get();
    }

    public WingsModel<S> getModel() {
        return this.model.get();
    }

    public class_2960 getTextureLocation() {
        return this.textureLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof WingForm)) return false;
        WingForm wingForm = (WingForm)obj;
        if (wingForm.resourceKey != this.resourceKey) return false;
        return true;
    }

    public static Optional<WingForm<?, ?>> get(class_6880<FlightApparatus> holder) {
        return Optional.of(WingFormRegistry.INSTANCE.createWings(holder));
    }

    public record FormRendererState<S>(FormRenderer<S> form, S state) {
        public void submitModel(class_4587 poseStack, class_11659 nodeCollector, Function<class_2960, class_1921> renderTypeGetter, int packedLight, int outlineColor) {
            this.form.submitModel(this.state, poseStack, nodeCollector, renderTypeGetter.apply(this.form.getTextureLocation()), packedLight, outlineColor);
        }
    }

    public static interface FormRenderer<S> {
        public class_2960 getTextureLocation();

        public S createRenderState(float var1);

        default public FormRendererState<S> pack(float partialTick) {
            return new FormRendererState<S>(this, this.createRenderState(partialTick));
        }

        public void submitModel(S var1, class_4587 var2, class_11659 var3, class_1921 var4, int var5, int var6);
    }
}

