/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightView;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.Flight;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1113;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class ClientEventHandler {
    public static final class_169<Optional<WingForm.FormRendererState<?>>> WING_FORM_KEY = new class_169(FantasticWings.id("wing_form"));
    public static final class_169<Float> FLYING_AMOUNT_KEY = new class_169(FantasticWings.id("flying_amount"));
    public static final class_169<Float> ROLL_KEY = new class_169(FantasticWings.id("roll"));
    public static final class_169<Float> PITCH_KEY = new class_169(FantasticWings.id("pitch"));

    public static void setupPlayerAnim(class_10055 renderState, class_572<class_10055> model) {
        float flyingAmount = ((Float)RenderStateExtraData.getOrDefault((class_10017)renderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount != 0.0f) {
            model.field_3398.field_3654 = MathHelper.toRadians(MathHelper.lerp(renderState.field_53448, renderState.field_53448 / 4.0f - 90.0f, flyingAmount));
            model.field_27433.field_3654 = MathHelper.lerp(model.field_27433.field_3654, -3.2f, flyingAmount);
            model.field_3401.field_3654 = MathHelper.lerp(model.field_3401.field_3654, -3.2f, flyingAmount);
            model.field_3397.field_3654 = MathHelper.lerp(model.field_3397.field_3654, 0.0f, flyingAmount);
            model.field_3392.field_3654 = MathHelper.lerp(model.field_3392.field_3654, 0.0f, flyingAmount);
        }
    }

    public static void setupPlayerRotations(class_10055 renderState, class_4587 poseStack) {
        float flyingAmount = ((Float)RenderStateExtraData.getOrDefault((class_10017)renderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount > 0.0f) {
            float roll = ((Float)RenderStateExtraData.getOrDefault((class_10017)renderState, ROLL_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            float pitch = ((Float)RenderStateExtraData.getOrDefault((class_10017)renderState, PITCH_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(MathHelper.lerpDegrees(0.0f, roll, flyingAmount)));
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(MathHelper.lerpDegrees(0.0f, pitch, flyingAmount)));
            poseStack.method_22904(0.0, -1.2 * (double)MathHelper.easeInOut(flyingAmount), 0.0);
        }
    }

    public static void onComputeCameraAngles(class_757 renderer, class_4184 camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.getOrDefault((Object)camera.method_19331(), (Object)Flight.VOID);
        float flyingAmount = flight.getFlyingAmount(partialTick);
        if (flyingAmount > 0.0f) {
            class_1657 player = (class_1657)camera.method_19331();
            float newRoll = MathHelper.lerpDegrees(player.field_6220 - player.field_5982, player.field_6283 - player.method_36454(), partialTick);
            roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
        }
    }

    public static EventResult onEntityLoad(class_1297 entity, class_638 level) {
        if (entity instanceof class_746) {
            class_746 localPlayer = (class_746)entity;
            Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)localPlayer);
            class_310.method_1551().method_1483().method_4873((class_1113)new WingsSound((class_1657)localPlayer, flight));
        }
        return EventResult.PASS;
    }

    public static void onExtractRenderState(class_1297 entity, class_10017 entityRenderState, float partialTick) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            if (entityRenderState instanceof class_10055) {
                class_10055 playerRenderState = (class_10055)entityRenderState;
                FlightView flightView = (FlightView)ClientModRegistry.FLIGHT_VIEW_ATTACHMENT_TYPE.getOrDefault((Object)entity, (Object)FlightView.VOID);
                flightView.ifFormPresent(form -> RenderStateExtraData.set((class_10017)entityRenderState, WING_FORM_KEY, Optional.of(form.pack(partialTick))));
                RenderStateExtraData.set((class_10017)entityRenderState, FLYING_AMOUNT_KEY, (Object)Float.valueOf(((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.getOrDefault((Object)player, (Object)Flight.VOID)).getFlyingAmount(partialTick)));
                float roll = MathHelper.lerpDegrees(player.field_6220 - player.field_5982, player.field_6283 - player.method_36454(), partialTick);
                RenderStateExtraData.set((class_10017)entityRenderState, ROLL_KEY, (Object)Float.valueOf(roll));
                float pitch = -MathHelper.lerpDegrees(player.field_6004, player.method_36455(), partialTick) - 90.0f;
                RenderStateExtraData.set((class_10017)entityRenderState, PITCH_KEY, (Object)Float.valueOf(pitch));
                if (ClientEventHandler.mustPreventCrouchingOffset((class_1657)player)) {
                    playerRenderState.field_53410 = false;
                }
            }
        }
    }

    private static boolean mustPreventCrouchingOffset(class_1657 player) {
        if (player.method_18276()) {
            Flight flight = (Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)player);
            return flight.isFlying() || !flight.isEmpty() && player.method_18798().method_10214() < -0.5;
        }
        return false;
    }

    public static EventResult onRenderOffHand(class_759 itemInHandRenderer, class_1268 interactionHand, class_742 player, class_1306 humanoidArm, class_1799 itemStack, class_4587 poseStack, class_11659 submitNodeCollector, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.method_7960() && !player.method_31550() && !player.method_5767() && !itemInHandRenderer.field_4047.method_31574(class_1802.field_8204) && ((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)player)).isFlying()) {
            itemInHandRenderer.method_3219(poseStack, submitNodeCollector, combinedLight, equipProgress, swingProgress, player.method_6068().method_5928());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(class_1297 entity, float deltaYaw) {
        float theta;
        class_1657 player;
        if (entity instanceof class_1657 && ((Flight)ModRegistry.FLIGHT_ATTACHMENT_TYPE.get((Object)(player = (class_1657)entity))).isFlying() && ((theta = class_3532.method_15393((float)(player.method_36454() - player.field_6283))) < -50.0f || theta > 50.0f)) {
            player.field_6283 += deltaYaw;
            player.field_6220 += deltaYaw;
        }
    }
}

