/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.client.model.geom.builders.FlatCubeListBuilder;
import fuzs.fantasticwings.client.renderer.entity.state.AvianRenderState;
import net.minecraft.class_243;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

public final class AvianWingsModel
extends WingsModel<AvianRenderState> {
    public static final int BONES = 4;
    public static final int FEATHERS = 4;
    private final ImmutableList<class_630> bonesLeft;
    private final ImmutableList<class_630> bonesRight;
    private final ImmutableList<class_630> feathersLeft;
    private final ImmutableList<class_630> feathersRight;

    public AvianWingsModel(class_630 modelPart) {
        super(modelPart);
        class_630 leftCoracoid = modelPart.method_32086("left_coracoid");
        class_630 rightCoracoid = modelPart.method_32086("right_coracoid");
        class_630 leftHumerus = leftCoracoid.method_32086("left_humerus");
        class_630 rightHumerus = rightCoracoid.method_32086("right_humerus");
        class_630 leftUlna = leftHumerus.method_32086("left_ulna");
        class_630 rightUlna = rightHumerus.method_32086("right_ulna");
        class_630 leftCarpals = leftUlna.method_32086("left_carpals");
        class_630 rightCarpals = rightUlna.method_32086("right_carpals");
        class_630 leftCoracoidFeathers = leftCoracoid.method_32086("left_coracoid_feathers");
        class_630 rightCoracoidFeathers = rightCoracoid.method_32086("right_coracoid_feathers");
        class_630 leftTertiaryFeathers = leftHumerus.method_32086("left_tertiary_feathers");
        class_630 rightTertiaryFeathers = rightHumerus.method_32086("right_tertiary_feathers");
        class_630 leftSecondaryFeathers = leftUlna.method_32086("left_secondary_feathers");
        class_630 rightSecondaryFeathers = rightUlna.method_32086("right_secondary_feathers");
        class_630 leftPrimaryFeathers = leftCarpals.method_32086("left_primary_feathers");
        class_630 rightPrimaryFeathers = rightCarpals.method_32086("right_primary_feathers");
        this.bonesLeft = ImmutableList.of((Object)leftCoracoid, (Object)leftHumerus, (Object)leftUlna, (Object)leftCarpals);
        this.bonesRight = ImmutableList.of((Object)rightCoracoid, (Object)rightHumerus, (Object)rightUlna, (Object)rightCarpals);
        this.feathersLeft = ImmutableList.of((Object)leftCoracoidFeathers, (Object)leftTertiaryFeathers, (Object)leftSecondaryFeathers, (Object)leftPrimaryFeathers);
        this.feathersRight = ImmutableList.of((Object)rightCoracoidFeathers, (Object)rightTertiaryFeathers, (Object)rightSecondaryFeathers, (Object)rightPrimaryFeathers);
        Preconditions.checkState((this.bonesLeft.size() == 4 && this.bonesRight.size() == 4 ? 1 : 0) != 0);
        Preconditions.checkState((this.feathersLeft.size() == 4 && this.feathersRight.size() == 4 ? 1 : 0) != 0);
    }

    public static class_5607 createWingsLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 root = meshDefinition.method_32111();
        class_5610 leftCoracoid = root.method_32117("left_coracoid", class_5606.method_32108().method_32101(0, 28).method_32097(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), class_5603.method_32090((float)1.5f, (float)5.5f, (float)2.5f));
        class_5610 rightCoracoid = root.method_32117("right_coracoid", class_5606.method_32108().method_32101(0, 34).method_32097(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), class_5603.method_32090((float)-1.5f, (float)5.5f, (float)2.5f));
        class_5610 leftHumerus = leftCoracoid.method_32117("left_humerus", class_5606.method_32108().method_32101(0, 0).method_32097(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), class_5603.method_32090((float)4.7f, (float)-0.6f, (float)0.1f));
        class_5610 rightHumerus = rightCoracoid.method_32117("right_humerus", class_5606.method_32108().method_32101(0, 7).method_32097(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), class_5603.method_32090((float)-4.7f, (float)-0.6f, (float)0.1f));
        class_5610 leftUlna = leftHumerus.method_32117("left_ulna", class_5606.method_32108().method_32101(22, 0).method_32097(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), class_5603.method_32090((float)6.5f, (float)0.2f, (float)0.1f));
        class_5610 rightUlna = rightHumerus.method_32117("right_ulna", class_5606.method_32108().method_32101(22, 6).method_32097(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), class_5603.method_32090((float)-6.5f, (float)0.2f, (float)0.1f));
        class_5610 leftCarpals = leftUlna.method_32117("left_carpals", class_5606.method_32108().method_32101(46, 0).method_32097(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), class_5603.method_32090((float)8.5f, (float)0.0f, (float)0.0f));
        class_5610 rightCarpals = rightUlna.method_32117("right_carpals", class_5606.method_32108().method_32101(46, 4).method_32097(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), class_5603.method_32090((float)-8.5f, (float)0.0f, (float)0.0f));
        leftCoracoid.method_32117("left_coracoid_feathers", FlatCubeListBuilder.create().method_32101(6, 40).method_32097(0.0f, 0.0f, -1.0f, 6.0f, 8.0f, 1.0f), class_5603.method_32090((float)0.4f, (float)0.0f, (float)1.0f));
        rightCoracoid.method_32117("right_coracoid_feathers", FlatCubeListBuilder.create().method_32101(0, 40).method_32097(-6.0f, 0.0f, -1.0f, 6.0f, 8.0f, 1.0f), class_5603.method_32090((float)-0.4f, (float)0.0f, (float)1.0f));
        leftHumerus.method_32117("left_tertiary_feathers", FlatCubeListBuilder.create().method_32101(10, 14).method_32097(0.0f, 0.0f, -0.5f, 10.0f, 14.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)1.5f, (float)1.0f));
        rightHumerus.method_32117("right_tertiary_feathers", FlatCubeListBuilder.create().method_32101(0, 14).method_32097(-10.0f, 0.0f, -0.5f, 10.0f, 14.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)1.5f, (float)1.0f));
        leftUlna.method_32117("left_secondary_feathers", FlatCubeListBuilder.create().method_32101(31, 14).method_32097(-2.0f, 0.0f, -0.5f, 11.0f, 12.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        rightUlna.method_32117("right_secondary_feathers", FlatCubeListBuilder.create().method_32101(20, 14).method_32097(-9.0f, 0.0f, -0.5f, 11.0f, 12.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        leftCarpals.method_32117("left_primary_feathers", FlatCubeListBuilder.create().method_32101(53, 14).method_32097(0.0f, -2.1f, -0.5f, 11.0f, 11.0f, 1.0f), class_5603.field_27701);
        rightCarpals.method_32117("right_primary_feathers", FlatCubeListBuilder.create().method_32101(42, 14).method_32097(-11.0f, -2.1f, -0.5f, 11.0f, 11.0f, 1.0f), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(AvianRenderState renderState) {
        class_630 right;
        class_630 left;
        int i;
        super.method_2819((Object)renderState);
        for (i = 0; i < 4; ++i) {
            left = (class_630)this.bonesLeft.get(i);
            right = (class_630)this.bonesRight.get(i);
            AvianWingsModel.setAngles(left, right, (class_243)renderState.wingAngles.getOrDefault(i, (Object)class_243.field_1353));
        }
        for (i = 0; i < 4; ++i) {
            left = (class_630)this.feathersLeft.get(i);
            right = (class_630)this.feathersRight.get(i);
            AvianWingsModel.setAngles(left, right, (class_243)renderState.featherAngles.getOrDefault(i, (Object)class_243.field_1353));
        }
    }
}

