/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight.apparatus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.WingSettings;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7995;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FlightApparatus(class_2960 textureLocation, Model model, WingSettings wingSettings) {
    public static final class_5321<class_2378<FlightApparatus>> REGISTRY_KEY = class_5321.method_29180((class_2960)FantasticWings.id("wings"));
    public static final Codec<FlightApparatus> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("asset_id").forGetter(FlightApparatus::textureLocation), (App)Model.CODEC.fieldOf("model").forGetter(FlightApparatus::model), (App)WingSettings.CODEC.fieldOf("wing_settings").forGetter(FlightApparatus::wingSettings)).apply((Applicative)instance, FlightApparatus::new));
    public static final class_9139<class_9129, FlightApparatus> DIRECT_STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, FlightApparatus::textureLocation, Model.STREAM_CODEC, FlightApparatus::model, WingSettings.STREAM_CODEC, FlightApparatus::wingSettings, FlightApparatus::new);
    public static final Codec<class_6880<FlightApparatus>> CODEC = class_6899.method_40400(REGISTRY_KEY);
    public static final class_9139<class_9129, class_6880<FlightApparatus>> STREAM_CODEC = class_9135.method_56383(REGISTRY_KEY);

    public static class_2960 transformTextureLocation(class_2960 resourceLocation) {
        return resourceLocation.method_45134(string -> "textures/" + string + ".png");
    }

    public static class_2960 getTextureLocation(class_5321<FlightApparatus> resourceKey) {
        return resourceKey.method_29177().method_45134(string -> "entity/equipment/wings/" + string);
    }

    public void onFlying(class_1657 player, class_243 direction) {
        int distance = Math.round((float)direction.method_1033() * 100.0f);
        if (distance > 0) {
            player.method_7322((float)distance * this.wingSettings().exhaustionFromFlying());
        }
    }

    public void onSlowlyDescending(class_1657 player, class_243 direction) {
        player.method_7322(this.wingSettings().exhaustionFromSlowlyDescending());
    }

    public boolean isUsableForFlying(class_1657 player) {
        return player.method_31549().field_7480 || player.method_7344().method_7586() >= this.wingSettings().requiredFoodLevelForFlying();
    }

    public boolean isUsableForSlowlyDescending(class_1657 player) {
        return player.method_31549().field_7480 || player.method_7344().method_7586() >= this.wingSettings().requiredFoodLevelForSlowlyDescending();
    }

    public static enum Model implements class_3542
    {
        AVIAN,
        INSECTOID;

        public static final class_3542.class_8808<Model> CODEC;
        public static final IntFunction<Model> BY_ID;
        public static final class_9139<ByteBuf, Model> STREAM_CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Model::values);
            BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])Model.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, Enum::ordinal);
        }
    }
}

