/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.world.item.consume_effects.GrantWingsConsumeEffect;
import fuzs.fantasticwings.world.item.consume_effects.TakeWingsConsumeEffect;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class WingsCommand {
    public static final String KEY_TAKE_WINGS_SINGLE = "commands.wings.take.success.single";
    public static final String KEY_TAKE_WINGS_MULTIPLE = "commands.wings.take.success.multiple";
    public static final String KEY_GIVE_WINGS_MULTIPLE = "commands.wings.give.success.multiple";
    public static final String KEY_GIVE_WINGS_SINGLE = "commands.wings.give.success.single";
    public static final MutableComponent COMPONENT_GIVE_WINGS_FAILED = Component.translatable((String)"commands.wings.give.failed");
    public static final MutableComponent COMPONENT_TAKE_WINGS_FAILED = Component.translatable((String)"commands.wings.take.failed");
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_GIVE_WINGS_FAILED);
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_TAKE_WINGS_FAILED);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wings").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"give").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"wings", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, FlightApparatus.REGISTRY_KEY)).executes(WingsCommand::giveWing))))).then(((LiteralArgumentBuilder)Commands.literal((String)"take").executes(ctx -> WingsCommand.takeWings((CommandContext<CommandSourceStack>)ctx, (Collection<ServerPlayer>)ImmutableList.of((Object)((CommandSourceStack)ctx.getSource()).getPlayerOrException())))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"wings", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, FlightApparatus.REGISTRY_KEY)).executes(WingsCommand::takeSpecificWings))).executes(ctx -> WingsCommand.takeWings((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"))))));
    }

    private static int giveWing(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        Holder.Reference holder = ResourceArgument.getResource(context, (String)"wings", FlightApparatus.REGISTRY_KEY);
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!GrantWingsConsumeEffect.giveWings(player, (Holder<FlightApparatus>)holder)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_GIVE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_GIVE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWings(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> targets) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!TakeWingsConsumeEffect.takeWings(player, Optional.empty())) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWings(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(context, (String)"targets");
        Holder.Reference holder = ResourceArgument.getResource(context, (String)"wings", FlightApparatus.REGISTRY_KEY);
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!TakeWingsConsumeEffect.takeWings(player, Optional.of(holder))) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }
}

