/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record FlightCapability(Optional<Holder<FlightApparatus>> wings, boolean isFlying, int timeFlying, int prevTimeFlying) {
    public static final Codec<FlightCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FlightApparatus.CODEC.optionalFieldOf("wing_type").forGetter(FlightCapability::wings), (App)Codec.BOOL.optionalFieldOf("is_flying", (Object)false).forGetter(FlightCapability::isFlying), (App)Codec.INT.optionalFieldOf("time_flying", (Object)0).forGetter(FlightCapability::timeFlying)).apply((Applicative)instance, FlightCapability::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlightCapability> STREAM_CODEC = StreamCodec.composite((StreamCodec)FlightApparatus.STREAM_CODEC.apply(ByteBufCodecs::optional), FlightCapability::wings, (StreamCodec)ByteBufCodecs.BOOL, FlightCapability::isFlying, (StreamCodec)ByteBufCodecs.INT, FlightCapability::timeFlying, FlightCapability::new);
    public static final FlightCapability VOID = new FlightCapability(Optional.empty(), false, 0);
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;

    public FlightCapability(Optional<Holder<FlightApparatus>> wings, boolean isFlying, int timeFlying) {
        this(wings, isFlying, timeFlying, timeFlying);
    }

    public FlightCapability setIsFlying(Player player, boolean isFlying) {
        if (this.isFlying != isFlying) {
            if (isFlying) {
                player.unRide();
            }
            return new FlightCapability(this.wings, isFlying, this.timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public FlightCapability toggleIsFlying(Player player) {
        return this.setIsFlying(player, !this.isFlying);
    }

    public FlightCapability setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            return new FlightCapability(this.wings, this.isFlying, timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public FlightCapability setPrevTimeFlying(int prevTimeFlying) {
        if (this.prevTimeFlying != prevTimeFlying) {
            return new FlightCapability(this.wings, this.isFlying, this.timeFlying, prevTimeFlying);
        }
        return this;
    }

    public FlightCapability setWings(@Nullable Holder<FlightApparatus> wings) {
        if (wings == null && this.wings.isPresent() || wings != null && !this.is(wings)) {
            return new FlightCapability(Optional.ofNullable(wings), this.isFlying, this.timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.wings.isEmpty();
    }

    public boolean is(Holder<FlightApparatus> flightApparatus) {
        Objects.requireNonNull(flightApparatus, "flight apparatus is null");
        return this.wings.filter(holder -> holder.is(flightApparatus)).isPresent();
    }

    public float getFlyingAmount(float partialTick) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, partialTick) / 20.0f);
    }

    public boolean canUseWings(Player player) {
        return !player.getAbilities().flying && !player.getItemBySlot(EquipmentSlot.CHEST).is(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly(Player player) {
        return this.canUseWings(player) && this.wings.filter(holder -> ((FlightApparatus)holder.value()).isUsableForFlying(player)).isPresent();
    }

    public boolean canSlowlyDescend(Player player) {
        return this.canUseWings(player) && this.wings.filter(holder -> ((FlightApparatus)holder.value()).isUsableForSlowlyDescending(player)).isPresent() && (this.isFlying() || !player.isDescending());
    }

    public static FlightCapability tick(FlightCapability flightCapability, Player player) {
        if (flightCapability.wings.isPresent() || !player.isEffectiveAi()) {
            flightCapability = FlightCapability.onWornUpdate(flightCapability, player);
        } else if (!player.level().isClientSide && flightCapability.isFlying()) {
            flightCapability = flightCapability.setIsFlying(player, false);
        }
        flightCapability = flightCapability.setPrevTimeFlying(flightCapability.timeFlying);
        if (flightCapability.isFlying()) {
            if (flightCapability.timeFlying < 20) {
                flightCapability = flightCapability.setTimeFlying(flightCapability.timeFlying + 1);
            } else if (player.isLocalPlayer() && player.onGround()) {
                flightCapability = flightCapability.setIsFlying(player, false);
                MessageSender.broadcast((Message)new ServerboundControlFlyingMessage(false));
            }
        } else if (flightCapability.timeFlying > 0) {
            flightCapability = flightCapability.setTimeFlying(flightCapability.timeFlying - 1);
        }
        return flightCapability;
    }

    private static FlightCapability onWornUpdate(FlightCapability flightCapability, Player player) {
        if (!player.level().isClientSide && flightCapability.isFlying() && !flightCapability.canFly(player)) {
            flightCapability = flightCapability.setIsFlying(player, false);
        }
        if (player.isEffectiveAi()) {
            if (flightCapability.isFlying()) {
                float speed = Mth.clampedLerp((float)0.03f, (float)0.0715f, (float)player.zza);
                float elevationBoost = MathHelper.transform(Math.abs(player.getXRot()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.getXRot() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.getYRot()) - (float)Math.PI;
                float vxz = -Mth.cos((float)pitch);
                float vy = Mth.sin((float)pitch);
                float vz = Mth.cos((float)yaw);
                float vx = Mth.sin((float)yaw);
                player.setDeltaMovement(player.getDeltaMovement().add((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.getXRot() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.jumping) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)0.03f, 0.0));
                } else if (player.isDescending()) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
                }
            }
            if (flightCapability.canSlowlyDescend(player)) {
                Vec3 deltaMovement = player.getDeltaMovement();
                if (deltaMovement.y() < 0.0) {
                    player.setDeltaMovement(deltaMovement.multiply(1.0, (double)0.9f, 1.0));
                }
                player.fallDistance = 0.0;
            }
        }
        return flightCapability;
    }

    public void onFlown(Player player, Vec3 direction) {
        this.wings.ifPresent(holder -> {
            if (this.isFlying()) {
                ((FlightApparatus)holder.value()).onFlying(player, direction);
            } else if (this.canSlowlyDescend(player) && player.getDeltaMovement().y() < -0.5) {
                ((FlightApparatus)holder.value()).onSlowlyDescending(player, direction);
            }
        });
    }
}

