/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.world.item;

import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.world.item.WithDescriptionItem;
import fuzs.fantasticwings.world.item.consume_effects.GrantWingsConsumeEffect;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.consume_effects.ConsumeEffect;

public class BottledWingsItem
extends WithDescriptionItem {
    public BottledWingsItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack createItemStack(Holder.Reference<FlightApparatus> holder) {
        ItemStack itemStack = new ItemStack(ModRegistry.BOTTLED_WINGS_ITEM);
        itemStack.set(DataComponents.CONSUMABLE, (Object)BottledWingsItem.createComponent(holder));
        return itemStack;
    }

    public static Consumable createComponent(Holder.Reference<FlightApparatus> holder) {
        return Consumables.defaultDrink().onConsume((ConsumeEffect)new GrantWingsConsumeEffect((Holder<FlightApparatus>)holder)).build();
    }

    public Component getName(ItemStack itemStack) {
        return BottledWingsItem.getFlightApparatus(itemStack).flatMap(Holder::unwrapKey).map(this::getWingsComponent).orElseGet(() -> super.getName(itemStack));
    }

    public Component getWingsComponent(ResourceKey<FlightApparatus> resourceKey) {
        return Component.translatable((String)(this.getDescriptionId() + ".wings." + resourceKey.location().toLanguageKey()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Holder<FlightApparatus>> getFlightApparatus(ItemStack itemStack) {
        Consumable consumable = (Consumable)itemStack.get(DataComponents.CONSUMABLE);
        if (consumable == null) return Optional.empty();
        for (ConsumeEffect consumeEffect : consumable.onConsumeEffects()) {
            if (!(consumeEffect instanceof GrantWingsConsumeEffect)) continue;
            GrantWingsConsumeEffect grantWingsConsumeEffect = (GrantWingsConsumeEffect)consumeEffect;
            try {
                Holder<FlightApparatus> holder;
                Holder<FlightApparatus> holder2 = holder = grantWingsConsumeEffect.holder();
                return Optional.of(holder2);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        return Optional.empty();
    }
}

