/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record FlightCapability(Optional<class_6880<FlightApparatus>> wings, boolean isFlying, int timeFlying, int prevTimeFlying) {
    public static final Codec<FlightCapability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FlightApparatus.CODEC.optionalFieldOf("wing_type").forGetter(FlightCapability::wings), (App)Codec.BOOL.optionalFieldOf("is_flying", (Object)false).forGetter(FlightCapability::isFlying), (App)Codec.INT.optionalFieldOf("time_flying", (Object)0).forGetter(FlightCapability::timeFlying)).apply((Applicative)instance, FlightCapability::new));
    public static final class_9139<class_9129, FlightCapability> STREAM_CODEC = class_9139.method_56436((class_9139)FlightApparatus.STREAM_CODEC.method_56433(class_9135::method_56382), FlightCapability::wings, (class_9139)class_9135.field_48547, FlightCapability::isFlying, (class_9139)class_9135.field_49675, FlightCapability::timeFlying, FlightCapability::new);
    public static final FlightCapability VOID = new FlightCapability(Optional.empty(), false, 0);
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;

    public FlightCapability(Optional<class_6880<FlightApparatus>> wings, boolean isFlying, int timeFlying) {
        this(wings, isFlying, timeFlying, timeFlying);
    }

    public FlightCapability setIsFlying(class_1657 player, boolean isFlying) {
        if (this.isFlying != isFlying) {
            if (isFlying) {
                player.method_18375();
            }
            return new FlightCapability(this.wings, isFlying, this.timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public FlightCapability toggleIsFlying(class_1657 player) {
        return this.setIsFlying(player, !this.isFlying);
    }

    public FlightCapability setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            return new FlightCapability(this.wings, this.isFlying, timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public FlightCapability setPrevTimeFlying(int prevTimeFlying) {
        if (this.prevTimeFlying != prevTimeFlying) {
            return new FlightCapability(this.wings, this.isFlying, this.timeFlying, prevTimeFlying);
        }
        return this;
    }

    public FlightCapability setWings(@Nullable class_6880<FlightApparatus> wings) {
        if (wings == null && this.wings.isPresent() || wings != null && !this.is(wings)) {
            return new FlightCapability(Optional.ofNullable(wings), this.isFlying, this.timeFlying, this.prevTimeFlying);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.wings.isEmpty();
    }

    public boolean is(class_6880<FlightApparatus> flightApparatus) {
        Objects.requireNonNull(flightApparatus, "flight apparatus is null");
        return this.wings.filter(holder -> holder.method_55838(flightApparatus)).isPresent();
    }

    public float getFlyingAmount(float partialTick) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, partialTick) / 20.0f);
    }

    public boolean canUseWings(class_1657 player) {
        return !player.method_31549().field_7479 && !player.method_6118(class_1304.field_6174).method_31573(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly(class_1657 player) {
        return this.canUseWings(player) && this.wings.filter(holder -> ((FlightApparatus)holder.comp_349()).isUsableForFlying(player)).isPresent();
    }

    public boolean canSlowlyDescend(class_1657 player) {
        return this.canUseWings(player) && this.wings.filter(holder -> ((FlightApparatus)holder.comp_349()).isUsableForSlowlyDescending(player)).isPresent() && (this.isFlying() || !player.method_21752());
    }

    public static FlightCapability tick(FlightCapability flightCapability, class_1657 player) {
        if (flightCapability.wings.isPresent() || !player.method_6034()) {
            flightCapability = FlightCapability.onWornUpdate(flightCapability, player);
        } else if (!player.method_37908().field_9236 && flightCapability.isFlying()) {
            flightCapability = flightCapability.setIsFlying(player, false);
        }
        flightCapability = flightCapability.setPrevTimeFlying(flightCapability.timeFlying);
        if (flightCapability.isFlying()) {
            if (flightCapability.timeFlying < 20) {
                flightCapability = flightCapability.setTimeFlying(flightCapability.timeFlying + 1);
            } else if (player.method_7340() && player.method_24828()) {
                flightCapability = flightCapability.setIsFlying(player, false);
                MessageSender.broadcast((Message)new ServerboundControlFlyingMessage(false));
            }
        } else if (flightCapability.timeFlying > 0) {
            flightCapability = flightCapability.setTimeFlying(flightCapability.timeFlying - 1);
        }
        return flightCapability;
    }

    private static FlightCapability onWornUpdate(FlightCapability flightCapability, class_1657 player) {
        if (!player.method_37908().field_9236 && flightCapability.isFlying() && !flightCapability.canFly(player)) {
            flightCapability = flightCapability.setIsFlying(player, false);
        }
        if (player.method_6034()) {
            if (flightCapability.isFlying()) {
                float speed = class_3532.method_37166((float)0.03f, (float)0.0715f, (float)player.field_6250);
                float elevationBoost = MathHelper.transform(Math.abs(player.method_36455()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.method_36455() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.method_36454()) - (float)Math.PI;
                float vxz = -class_3532.method_15362((float)pitch);
                float vy = class_3532.method_15374((float)pitch);
                float vz = class_3532.method_15362((float)yaw);
                float vx = class_3532.method_15374((float)yaw);
                player.method_18799(player.method_18798().method_1031((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.method_36455() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.field_6282) {
                    player.method_18799(player.method_18798().method_1031(0.0, (double)0.03f, 0.0));
                } else if (player.method_21752()) {
                    player.method_18799(player.method_18798().method_1031(0.0, (double)-0.06f, 0.0));
                }
            }
            if (flightCapability.canSlowlyDescend(player)) {
                class_243 deltaMovement = player.method_18798();
                if (deltaMovement.method_10214() < 0.0) {
                    player.method_18799(deltaMovement.method_18805(1.0, (double)0.9f, 1.0));
                }
                player.field_6017 = 0.0;
            }
        }
        return flightCapability;
    }

    public void onFlown(class_1657 player, class_243 direction) {
        this.wings.ifPresent(holder -> {
            if (this.isFlying()) {
                ((FlightApparatus)holder.comp_349()).onFlying(player, direction);
            } else if (this.canSlowlyDescend(player) && player.method_18798().method_10214() < -0.5) {
                ((FlightApparatus)holder.comp_349()).onSlowlyDescending(player, direction);
            }
        });
    }
}

