/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightView;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;

public class ClientEventHandler {
    public static final RenderPropertyKey<FlightView> FLIGHT_VIEW_RENDER_PROPERTY_KEY = new RenderPropertyKey(FantasticWings.id("flight_view"));
    public static final RenderPropertyKey<Float> FLYING_AMOUNT_RENDER_PROPERTY_KEY = new RenderPropertyKey(FantasticWings.id("flying_amount"));
    public static final RenderPropertyKey<Float> ROLL_RENDER_PROPERTY_KEY = new RenderPropertyKey(FantasticWings.id("roll"));
    public static final RenderPropertyKey<Float> PITCH_RENDER_PROPERTY_KEY = new RenderPropertyKey(FantasticWings.id("pitch"));

    public static void setupPlayerAnim(PlayerRenderState renderState, HumanoidModel<PlayerRenderState> model) {
        float flyingAmount = ((Float)RenderPropertyKey.getOrDefault((EntityRenderState)renderState, FLYING_AMOUNT_RENDER_PROPERTY_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount != 0.0f) {
            model.head.xRot = MathHelper.toRadians(MathHelper.lerp(renderState.xRot, renderState.xRot / 4.0f - 90.0f, flyingAmount));
            model.leftArm.xRot = MathHelper.lerp(model.leftArm.xRot, -3.2f, flyingAmount);
            model.rightArm.xRot = MathHelper.lerp(model.rightArm.xRot, -3.2f, flyingAmount);
            model.leftLeg.xRot = MathHelper.lerp(model.leftLeg.xRot, 0.0f, flyingAmount);
            model.rightLeg.xRot = MathHelper.lerp(model.rightLeg.xRot, 0.0f, flyingAmount);
            model.hat.copyFrom(model.head);
        }
    }

    public static void setupPlayerRotations(PlayerRenderState renderState, PoseStack poseStack) {
        float flyingAmount = ((Float)RenderPropertyKey.getOrDefault((EntityRenderState)renderState, FLYING_AMOUNT_RENDER_PROPERTY_KEY, (Object)Float.valueOf(0.0f))).floatValue();
        if (flyingAmount > 0.0f) {
            float roll = ((Float)RenderPropertyKey.getOrDefault((EntityRenderState)renderState, ROLL_RENDER_PROPERTY_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            float pitch = ((Float)RenderPropertyKey.getOrDefault((EntityRenderState)renderState, PITCH_RENDER_PROPERTY_KEY, (Object)Float.valueOf(0.0f))).floatValue();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(MathHelper.lerpDegrees(0.0f, roll, flyingAmount)));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(MathHelper.lerpDegrees(0.0f, pitch, flyingAmount)));
            poseStack.translate(0.0, -1.2 * (double)MathHelper.easeInOut(flyingAmount), 0.0);
        }
    }

    public static void onComputeCameraAngles(GameRenderer renderer, Camera camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        LivingEntity cameraEntity = (LivingEntity)camera.getEntity();
        ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)cameraEntity).ifPresent(flightViewCapability -> {
            float flyingAmount = flightViewCapability.getFlyingAmount(partialTick);
            if (flyingAmount > 0.0f) {
                float newRoll = MathHelper.lerpDegrees(cameraEntity.yBodyRotO - cameraEntity.yRotO, cameraEntity.yBodyRot - cameraEntity.getYRot(), partialTick);
                roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
            }
        });
    }

    public static EventResult onEntityLoad(Entity entity, ClientLevel level) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)localPlayer);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new WingsSound((Player)localPlayer, flightCapability));
        }
        return EventResult.PASS;
    }

    public static void onExtractRenderState(Entity entity, EntityRenderState entityRenderState, float partialTick) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            if (entityRenderState instanceof PlayerRenderState) {
                PlayerRenderState playerRenderState = (PlayerRenderState)entityRenderState;
                RenderPropertyKey.set((EntityRenderState)entityRenderState, FLIGHT_VIEW_RENDER_PROPERTY_KEY, (Object)((FlightView)ClientModRegistry.FLIGHT_VIEW_ATTACHMENT_TYPE.get((Object)entity)));
                RenderPropertyKey.set((EntityRenderState)entityRenderState, FLYING_AMOUNT_RENDER_PROPERTY_KEY, (Object)Float.valueOf(((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).getFlyingAmount(partialTick)));
                float roll = MathHelper.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), partialTick);
                RenderPropertyKey.set((EntityRenderState)entityRenderState, ROLL_RENDER_PROPERTY_KEY, (Object)Float.valueOf(roll));
                float pitch = -MathHelper.lerpDegrees(player.xRotO, player.getXRot(), partialTick) - 90.0f;
                RenderPropertyKey.set((EntityRenderState)entityRenderState, PITCH_RENDER_PROPERTY_KEY, (Object)Float.valueOf(pitch));
                if (ClientEventHandler.mustPreventCrouchingOffset((Player)player)) {
                    playerRenderState.isCrouching = false;
                }
            }
        }
    }

    private static boolean mustPreventCrouchingOffset(Player player) {
        if (player.isCrouching()) {
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
            return flightCapability.isFlying() || !flightCapability.isEmpty() && player.getDeltaMovement().y() < -0.5;
        }
        return false;
    }

    public static EventResult onRenderOffHand(ItemInHandRenderer itemInHandRenderer, InteractionHand interactionHand, AbstractClientPlayer player, HumanoidArm humanoidArm, ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.isEmpty() && !player.isScoping() && !player.isInvisible() && !itemInHandRenderer.mainHandItem.is(Items.FILLED_MAP) && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).isFlying()) {
            itemInHandRenderer.renderPlayerArm(poseStack, bufferSource, combinedLight, equipProgress, swingProgress, player.getMainArm().getOpposite());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(Entity entity, float deltaYaw) {
        float theta;
        Player player;
        if (entity instanceof Player && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)(player = (Player)entity))).isFlying() && ((theta = Mth.wrapDegrees((float)(player.getYRot() - player.yBodyRot))) < -50.0f || theta > 50.0f)) {
            player.yBodyRot += deltaYaw;
            player.yBodyRotO += deltaYaw;
        }
    }
}

