/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import com.mojang.serialization.DynamicOps;
import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class FlightCapability
extends CapabilityComponent<Player> {
    private static final String KEY_IS_FLYING = FantasticWings.id("is_flying").toString();
    private static final String KEY_TIME_FLYING = FantasticWings.id("time_flying").toString();
    private static final String KEY_WING_TYPE = FantasticWings.id("wing_type").toString();
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private Optional<Holder<FlightApparatus>> holder = Optional.empty();

    public void setIsFlying(Player player, boolean isFlying) {
        this.setIsFlying(player, isFlying, null);
    }

    public void setIsFlying(Player player, boolean isFlying, @Nullable PlayerSet playerSet) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            if (this.isFlying) {
                player.unRide();
            }
            this.setChanged(playerSet);
        }
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void toggleIsFlying(Player player, PlayerSet playerSet) {
        this.setIsFlying(player, !this.isFlying, playerSet);
    }

    public void setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            this.timeFlying = timeFlying;
            this.setChanged(PlayerSet.ofNone());
        }
    }

    public boolean setWings(@Nullable Holder<FlightApparatus> flightApparatus) {
        if (flightApparatus == null && this.holder.isPresent() || flightApparatus != null && !this.is(flightApparatus)) {
            this.holder = Optional.ofNullable(flightApparatus);
            this.setChanged();
            return true;
        }
        return false;
    }

    public Optional<Holder<FlightApparatus>> getWings() {
        return this.holder;
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public boolean is(Holder<FlightApparatus> flightApparatus) {
        Objects.requireNonNull(flightApparatus, "flight apparatus is null");
        return this.holder.filter(holder -> holder.is(flightApparatus)).isPresent();
    }

    public float getFlyingAmount(float partialTick) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, partialTick) / 20.0f);
    }

    public boolean canUseWings(Player player) {
        return !player.getAbilities().flying && !player.getItemBySlot(EquipmentSlot.CHEST).is(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly(Player player) {
        return this.canUseWings(player) && this.holder.filter(holder -> ((FlightApparatus)holder.value()).isUsableForFlying(player)).isPresent();
    }

    public boolean canSlowlyDescend(Player player) {
        return this.canUseWings(player) && this.holder.filter(holder -> ((FlightApparatus)holder.value()).isUsableForSlowlyDescending(player)).isPresent() && (this.isFlying() || !player.isDescending() && !player.getAbilities().mayfly);
    }

    private void onWornUpdate(Player player) {
        if (!player.level().isClientSide && this.isFlying() && !this.canFly(player)) {
            this.setIsFlying(player, false);
        }
        if (player.isEffectiveAi()) {
            if (this.isFlying()) {
                float speed = Mth.clampedLerp((float)0.03f, (float)0.0715f, (float)player.zza);
                float elevationBoost = MathHelper.transform(Math.abs(player.getXRot()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.getXRot() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.getYRot()) - (float)Math.PI;
                float vxz = -Mth.cos((float)pitch);
                float vy = Mth.sin((float)pitch);
                float vz = Mth.cos((float)yaw);
                float vx = Mth.sin((float)yaw);
                player.setDeltaMovement(player.getDeltaMovement().add((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.getXRot() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.jumping) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)0.03f, 0.0));
                } else if (player.isDescending()) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)-0.06f, 0.0));
                }
            }
            if (this.canSlowlyDescend(player)) {
                Vec3 deltaMovement = player.getDeltaMovement();
                if (deltaMovement.y() < 0.0) {
                    player.setDeltaMovement(deltaMovement.multiply(1.0, (double)0.9f, 1.0));
                }
                player.fallDistance = 0.0;
            }
        }
    }

    public void tick(Player player) {
        if (this.holder.isPresent() || !player.isEffectiveAi()) {
            this.onWornUpdate(player);
        } else if (!player.level().isClientSide && this.isFlying()) {
            this.setIsFlying(player, false);
        }
        this.prevTimeFlying = this.timeFlying;
        if (this.isFlying()) {
            if (this.timeFlying < 20) {
                this.setTimeFlying(this.timeFlying + 1);
            } else if (player.isLocalPlayer() && player.onGround()) {
                this.setIsFlying(player, false, PlayerSet.ofNone());
                MessageSender.broadcast((Message)new ServerboundControlFlyingMessage(false));
            }
        } else if (this.timeFlying > 0) {
            this.setTimeFlying(this.timeFlying - 1);
        }
    }

    public void onFlown(Player player, Vec3 direction) {
        this.holder.ifPresent(holder -> {
            if (this.isFlying()) {
                ((FlightApparatus)holder.value()).onFlying(player, direction);
            } else if (this.canSlowlyDescend(player) && player.getDeltaMovement().y() < -0.5) {
                ((FlightApparatus)holder.value()).onSlowlyDescending(player, direction);
            }
        });
    }

    public void write(CompoundTag compoundTag, HolderLookup.Provider registries) {
        compoundTag.putBoolean(KEY_IS_FLYING, this.isFlying);
        compoundTag.putInt(KEY_TIME_FLYING, this.timeFlying);
        compoundTag.storeNullable(KEY_WING_TYPE, FlightApparatus.CODEC, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.holder.orElse(null));
    }

    public void read(CompoundTag compoundTag, HolderLookup.Provider registries) {
        this.isFlying = compoundTag.getBooleanOr(KEY_IS_FLYING, false);
        this.timeFlying = compoundTag.getIntOr(KEY_TIME_FLYING, 0);
        this.holder = compoundTag.read(KEY_WING_TYPE, FlightApparatus.CODEC, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE));
    }
}

