/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.handler;

import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ServerEventHandler {
    public static EventResult onAttackEntity(Player player, Level level, InteractionHand interactionHand, Entity entity) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (entity.getType() == EntityType.BAT && itemInHand.is(Items.GLASS_BOTTLE)) {
            level.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            ItemStack originalItemInHand = itemInHand.copy();
            if (!player.getAbilities().instabuild) {
                itemInHand.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)Items.GLASS_BOTTLE));
            ItemStack itemStack = new ItemStack(ModRegistry.BOTTLED_BAT_BLOOD_ITEM);
            if (itemInHand.isEmpty()) {
                ItemHelper.onPlayerDestroyItem((Player)player, (ItemStack)originalItemInHand, (InteractionHand)interactionHand);
                player.setItemInHand(interactionHand, itemStack);
            } else if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onStartRiding(Level level, Entity rider, Entity vehicle) {
        return ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)rider).filter(FlightCapability::isFlying).isPresent() ? EventResult.INTERRUPT : EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).tick(player);
    }

    public static boolean onUpdateBodyRotation(LivingEntity living, float movementYaw) {
        Player player;
        if (living instanceof Player && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)(player = (Player)living))).isFlying()) {
            living.yBodyRot += Mth.wrapDegrees((float)(movementYaw - living.yBodyRot)) * 0.3f;
            float theta = Mth.clamp((float)Mth.wrapDegrees((float)(living.getYRot() - living.yBodyRot)), (float)-50.0f, (float)50.0f);
            living.yBodyRot = living.getYRot() - theta;
            return true;
        }
        return false;
    }
}

