/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight.apparatus;

import fuzs.fantasticwings.client.animator.AnimatorAvian;
import fuzs.fantasticwings.client.animator.AnimatorInsectoid;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.model.AvianWingsModel;
import fuzs.fantasticwings.client.model.InsectoidWingsModel;
import fuzs.fantasticwings.client.model.WingsModel;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.puzzleslib.api.client.init.v1.ModelLayerFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public final class WingFormRegistry
implements ResourceManagerReloadListener {
    static final ModelLayerFactory MODEL_LAYERS = ModelLayerFactory.from((String)"fantasticwings");
    public static final ModelLayerLocation AVIAN_WINGS_MODEL_LAYER = MODEL_LAYERS.registerModelLayer("avian_wings");
    public static final ModelLayerLocation INSECTOID_WINGS_MODEL_LAYER = MODEL_LAYERS.registerModelLayer("insectoid_wings");
    public static final WingFormRegistry INSTANCE = new WingFormRegistry();
    private WingsModel<AnimatorAvian> avianWings;
    private WingsModel<AnimatorInsectoid> insectoidWings;

    private WingFormRegistry() {
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        EntityModelSet entityModels = Minecraft.getInstance().getEntityModels();
        this.avianWings = new AvianWingsModel(entityModels.bakeLayer(AVIAN_WINGS_MODEL_LAYER));
        this.insectoidWings = new InsectoidWingsModel(entityModels.bakeLayer(INSECTOID_WINGS_MODEL_LAYER));
    }

    public WingForm<?> createWings(Holder<FlightApparatus> holder) {
        ResourceKey resourceKey = (ResourceKey)holder.unwrapKey().orElseThrow();
        return switch (((FlightApparatus)holder.value()).model()) {
            default -> throw new MatchException(null, null);
            case FlightApparatus.Model.AVIAN -> new WingForm<AnimatorAvian>((ResourceKey<FlightApparatus>)resourceKey, AnimatorAvian::new, () -> this.avianWings);
            case FlightApparatus.Model.INSECTOID -> new WingForm<AnimatorInsectoid>((ResourceKey<FlightApparatus>)resourceKey, AnimatorInsectoid::new, () -> this.insectoidWings);
        };
    }
}

