/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.client.flight.FlightView;
import fuzs.fantasticwings.client.flight.apparatus.WingFormRegistry;
import fuzs.fantasticwings.client.handler.ClientEventHandler;
import fuzs.fantasticwings.client.handler.PotionItemModelHandler;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.client.model.AvianWingsModel;
import fuzs.fantasticwings.client.model.InsectoidWingsModel;
import fuzs.fantasticwings.client.renderer.entity.layers.LayerWings;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.AdditionalModelsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.AddResourcePackReloadListenersCallback;
import fuzs.puzzleslib.api.client.event.v1.ModelEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.ClientEntityLevelEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ExtractRenderStateCallbackV2;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandEvents;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationHandler;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;

public class FantasticWingsClient
implements ClientModConstructor {
    public static final ResourceLocation BAT_BLOOD_BOTTLE_TEXTURE_LOCATION = FantasticWings.id("bat_blood_bottle");

    public void onConstructMod() {
        ClientModRegistry.bootstrap();
        FantasticWingsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ComputeCameraAnglesCallback.EVENT.register(ClientEventHandler::onComputeCameraAngles);
        ClientEntityLevelEvents.LOAD.register(ClientEventHandler::onEntityLoad);
        PlayerTickEvents.END.register(FlightView::onEndPlayerTick);
        ExtractRenderStateCallbackV2.EVENT.register(ClientEventHandler::onExtractRenderState);
        RenderHandEvents.OFF_HAND.register(ClientEventHandler::onRenderOffHand);
        ModelEvents.MODIFY_UNBAKED_MODEL.register(PotionItemModelHandler::onModifyUnbakedModel);
        AddResourcePackReloadListenersCallback.EVENT.register(consumer -> consumer.accept(FantasticWings.id("wing_models"), WingFormRegistry.INSTANCE));
    }

    public void onClientSetup() {
        WingFormRegistry.INSTANCE.registerAll();
    }

    public void onRegisterKeyMappings(KeyMappingsContext context) {
        context.registerKeyMapping(ClientModRegistry.FLY_KEY_MAPPING, KeyActivationHandler.forGame(minecraft -> {
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)minecraft.player);
            if (flightCapability.canFly()) {
                flightCapability.toggleIsFlying(PlayerSet.ofNone());
                FantasticWings.NETWORK.sendMessage((ServerboundMessage)new ServerboundControlFlyingMessage(flightCapability.isFlying()));
            }
        }));
    }

    public void onRegisterAdditionalModels(AdditionalModelsContext context) {
        FlightApparatusImpl.forEach(flightApparatus -> context.registerAdditionalModel(new ResourceLocation[]{flightApparatus.modelLocation()}));
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        FlightApparatusImpl.forEach(flightApparatus -> FantasticWingsClient.registerPotionItemModelProperty(context, flightApparatus.textureLocation(), flightApparatus.getPotion()));
    }

    private static void registerPotionItemModelProperty(ItemModelPropertiesContext context, ResourceLocation itemModelProperty, Holder<Potion> potion) {
        context.registerItemProperty(itemModelProperty, (itemStack, clientLevel, livingEntity, i) -> {
            Optional optional = ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion();
            return optional.filter(potionHolder -> potionHolder.is(potion)).isPresent() ? 1.0f : 0.0f;
        }, (ItemLike[])PotionItemModelHandler.POTION_ITEMS);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ClientModRegistry.INSECTOID_WINGS, InsectoidWingsModel::createWingsLayer);
        context.registerLayerDefinition(ClientModRegistry.AVIAN_WINGS, AvianWingsModel::createWingsLayer);
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(EntityType.PLAYER, LayerWings::new);
    }
}

