/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.data.client;

import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.commands.WingsCommand;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractLanguageProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;

public class ModLanguageProvider
extends AbstractLanguageProvider {
    public ModLanguageProvider(DataProviderContext context) {
        super(context);
    }

    public void addTranslations(AbstractLanguageProvider.TranslationBuilder builder) {
        builder.addCreativeModeTab("fantasticwings", "Fantastic Wings");
        builder.addKeyCategory("fantasticwings", "Fantastic Wings");
        builder.add(ClientModRegistry.FLY_KEY_MAPPING, "Toggle Flight");
        builder.add("wings.wingsNotFound", "No such wings: %s");
        builder.add("commands.wings.give.success.single", "Applied wings to %s");
        builder.add("commands.wings.give.success.multiple", "Applied wings to %s targets");
        builder.add("commands.wings.take.success.single", "Removed wings from %s");
        builder.add("commands.wings.take.success.multiple", "Removed wings from %s targets");
        builder.add((Component)WingsCommand.COMPONENT_GIVE_WINGS_FAILED, "Unable to apply wings to target");
        builder.add((Component)WingsCommand.COMPONENT_TAKE_WINGS_FAILED, "Target doesn't have wings to remove");
        builder.add((MobEffect)ModRegistry.GROW_WINGS_MOB_EFFECT.value(), "Grow Wings");
        builder.add((MobEffect)ModRegistry.SHED_WINGS_MOB_EFFECT.value(), "Shed Wings");
        ModLanguageProvider.addPotion(builder, ModRegistry.BAT_BLOOD_POTION, "Bat Blood");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.ANGEL.getPotion(), "Angel Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.BAT.getPotion(), "Bat Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.BLUE_BUTTERFLY.getPotion(), "Blue Butterfly Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.DRAGON.getPotion(), "Dragon Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.EVIL.getPotion(), "Evil Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.FAIRY.getPotion(), "Fairy Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.FIRE.getPotion(), "Fire Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.MONARCH_BUTTERFLY.getPotion(), "Monarch Butterfly Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.PARROT.getPotion(), "Parrot Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.SLIME.getPotion(), "Slime Wings");
        ModLanguageProvider.addPotion(builder, FlightApparatusImpl.METALLIC.getPotion(), "Metallic Wings");
        builder.add((SoundEvent)ModRegistry.ITEM_ARMOR_EQUIP_WINGS.value(), "Wings rustle");
    }

    private static void addPotion(AbstractLanguageProvider.TranslationBuilder builder, Holder<Potion> potion, String value) {
        Objects.requireNonNull(potion, "potion is null");
        Function<Item, Component> potionNameGetter = item -> new PotionContents(potion).getName(item.getDescriptionId() + ".effect.");
        builder.add(potionNameGetter.apply(Items.TIPPED_ARROW), "Arrow of " + value);
        builder.add(potionNameGetter.apply(Items.POTION), value + " Bottle");
        builder.add(potionNameGetter.apply(Items.SPLASH_POTION), "Splash " + value + " Bottle");
        builder.add(potionNameGetter.apply(Items.LINGERING_POTION), "Lingering " + value + " Bottle");
    }
}

