/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight;

import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.animator.state.State;
import fuzs.fantasticwings.client.animator.state.StateIdle;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public record FlightView(WingState animator) {
    public static final FlightView VOID = new FlightView(PresentWingState.VOID);

    public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    public static void onEndPlayerTick(class_1657 player) {
        ClientModRegistry.FLIGHT_VIEW_ATTACHMENT_TYPE.update((Object)player, flightView -> flightView.tick(player));
    }

    private FlightView tick(class_1657 player) {
        WingState animator = WingForm.get(this.getFlight(player).getWings().flightApparatus()).map(this.animator::next).orElseGet(this.animator::nextAbsent);
        animator.update(this.getFlight(player), player);
        return new FlightView(animator);
    }

    public boolean resetEyeHeight(class_1657 player) {
        return this.getFlight(player).isFlying() || this.getFlight(player).getFlyingAmount(1.0f) > 0.0f && player.method_18376() == class_4050.field_18077;
    }

    public FlightCapability getFlight(class_1657 player) {
        return (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(FlightCapability var1, class_1657 var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }

    private record PresentWingState(WingForm<?> wing, Strategy behavior) implements WingState
    {
        static final WingState VOID = new WingState(){

            @Override
            public WingState nextAbsent() {
                return this;
            }

            @Override
            public WingState next(WingForm<?> form) {
                return PresentWingState.newState(form);
            }

            @Override
            public void update(FlightCapability flight, class_1657 player) {
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            }
        };

        @Override
        public WingState nextAbsent() {
            return VOID;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(FlightCapability flight, class_1657 player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(FlightCapability flight, class_1657 player) {
                this.animator.update();
                State state = this.state.update(flight, player.method_23317() - player.field_6014, player.method_23318() - player.field_6036, player.method_23321() - player.field_5969, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
                consumer.accept(new WingForm.FormRenderer(){

                    @Override
                    public class_2960 getTextureLocation() {
                        return shape.getTextureLocation();
                    }

                    @Override
                    public void render(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color, float partialTick) {
                        shape.getModel().render(animator, partialTick, poseStack, buffer, packedLight, packedOverlay, color);
                    }
                });
            }
        }
    }

    private static interface Strategy {
        public void update(FlightCapability var1, class_1657 var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }
}

