/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.fantasticwings.client.animator.AnimatorAvian;
import fuzs.fantasticwings.client.model.Model3DTexture;
import fuzs.fantasticwings.client.model.WingsModel;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

public final class AvianWingsModel
extends WingsModel<AnimatorAvian> {
    private final class_630 root;
    private final ImmutableList<class_630> bonesLeft;
    private final ImmutableList<class_630> bonesRight;
    private final ImmutableList<class_630> feathersLeft;
    private final ImmutableList<class_630> feathersRight;

    public AvianWingsModel(class_630 modelPart) {
        this.root = modelPart;
        class_630 leftCoracoid = modelPart.method_32086("left_coracoid");
        class_630 rightCoracoid = modelPart.method_32086("right_coracoid");
        class_630 leftHumerus = leftCoracoid.method_32086("left_humerus");
        class_630 rightHumerus = rightCoracoid.method_32086("right_humerus");
        class_630 leftUlna = leftHumerus.method_32086("left_ulna");
        class_630 rightUlna = rightHumerus.method_32086("right_ulna");
        class_630 leftCarpals = leftUlna.method_32086("left_carpals");
        class_630 rightCarpals = rightUlna.method_32086("right_carpals");
        class_630 leftCoracoidFeathers = leftCoracoid.method_32086("left_coracoid_feathers");
        AvianWingsModel.add3DTexture(leftCoracoidFeathers, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        class_630 rightCoracoidFeathers = rightCoracoid.method_32086("right_coracoid_feathers");
        AvianWingsModel.add3DTexture(rightCoracoidFeathers, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        class_630 leftTertiaryFeathers = leftHumerus.method_32086("left_tertiary_feathers");
        AvianWingsModel.add3DTexture(leftTertiaryFeathers, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        class_630 rightTertiaryFeathers = rightHumerus.method_32086("right_tertiary_feathers");
        AvianWingsModel.add3DTexture(rightTertiaryFeathers, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        class_630 leftSecondaryFeathers = leftUlna.method_32086("left_secondary_feathers");
        AvianWingsModel.add3DTexture(leftSecondaryFeathers, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        class_630 rightSecondaryFeathers = rightUlna.method_32086("right_secondary_feathers");
        AvianWingsModel.add3DTexture(rightSecondaryFeathers, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        class_630 leftPrimaryFeathers = leftCarpals.method_32086("left_primary_feathers");
        AvianWingsModel.add3DTexture(leftPrimaryFeathers, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        class_630 rightPrimaryFeathers = rightCarpals.method_32086("right_primary_feathers");
        AvianWingsModel.add3DTexture(rightPrimaryFeathers, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)leftCoracoid, (Object)leftHumerus, (Object)leftUlna, (Object)leftCarpals);
        this.bonesRight = ImmutableList.of((Object)rightCoracoid, (Object)rightHumerus, (Object)rightUlna, (Object)rightCarpals);
        this.feathersLeft = ImmutableList.of((Object)leftCoracoidFeathers, (Object)leftTertiaryFeathers, (Object)leftSecondaryFeathers, (Object)leftPrimaryFeathers);
        this.feathersRight = ImmutableList.of((Object)rightCoracoidFeathers, (Object)rightTertiaryFeathers, (Object)rightSecondaryFeathers, (Object)rightPrimaryFeathers);
    }

    public static class_5607 createWingsLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 root = meshDefinition.method_32111();
        class_5610 leftCoracoid = root.method_32117("left_coracoid", class_5606.method_32108().method_32101(0, 28).method_32097(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), class_5603.method_32090((float)1.5f, (float)5.5f, (float)2.5f));
        class_5610 rightCoracoid = root.method_32117("right_coracoid", class_5606.method_32108().method_32101(0, 34).method_32097(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), class_5603.method_32090((float)-1.5f, (float)5.5f, (float)2.5f));
        class_5610 leftHumerus = leftCoracoid.method_32117("left_humerus", class_5606.method_32108().method_32101(0, 0).method_32097(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), class_5603.method_32090((float)4.7f, (float)-0.6f, (float)0.1f));
        class_5610 rightHumerus = rightCoracoid.method_32117("right_humerus", class_5606.method_32108().method_32101(0, 7).method_32097(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), class_5603.method_32090((float)-4.7f, (float)-0.6f, (float)0.1f));
        class_5610 leftUlna = leftHumerus.method_32117("left_ulna", class_5606.method_32108().method_32101(22, 0).method_32097(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), class_5603.method_32090((float)6.5f, (float)0.2f, (float)0.1f));
        class_5610 rightUlna = rightHumerus.method_32117("right_ulna", class_5606.method_32108().method_32101(22, 6).method_32097(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), class_5603.method_32090((float)-6.5f, (float)0.2f, (float)0.1f));
        class_5610 leftCarpals = leftUlna.method_32117("left_carpals", class_5606.method_32108().method_32101(46, 0).method_32097(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), class_5603.method_32090((float)8.5f, (float)0.0f, (float)0.0f));
        class_5610 rightCarpals = rightUlna.method_32117("right_carpals", class_5606.method_32108().method_32101(46, 4).method_32097(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), class_5603.method_32090((float)-8.5f, (float)0.0f, (float)0.0f));
        class_5610 leftCoracoidFeathers = leftCoracoid.method_32117("left_coracoid_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.4f, (float)0.0f, (float)1.0f));
        class_5610 rightCoracoidFeathers = rightCoracoid.method_32117("right_coracoid_feathers", class_5606.method_32108(), class_5603.method_32090((float)-0.4f, (float)0.0f, (float)1.0f));
        class_5610 leftTertiaryFeathers = leftHumerus.method_32117("left_tertiary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)1.5f, (float)1.0f));
        class_5610 rightTertiaryFeathers = rightHumerus.method_32117("right_tertiary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)1.5f, (float)1.0f));
        class_5610 leftSecondaryFeathers = leftUlna.method_32117("left_secondary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        class_5610 rightSecondaryFeathers = rightUlna.method_32117("right_secondary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        class_5610 leftPrimaryFeathers = leftCarpals.method_32117("left_primary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 rightPrimaryFeathers = rightCarpals.method_32117("right_primary_feathers", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void render(AnimatorAvian animator, float partialTick, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        class_630 right;
        class_630 left;
        int i;
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (class_630)this.bonesLeft.get(i);
            right = (class_630)this.bonesRight.get(i);
            AvianWingsModel.setAngles(left, right, animator.getWingRotation(i, partialTick));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (class_630)this.feathersLeft.get(i);
            right = (class_630)this.feathersRight.get(i);
            AvianWingsModel.setAngles(left, right, animator.getFeatherRotation(i, partialTick));
        }
        this.root.method_22699(poseStack, buffer, packedLight, packedOverlay, color);
    }

    private static void add3DTexture(class_630 model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        Preconditions.checkState((boolean)model.field_3663.isEmpty(), (Object)"model part cube list is not empty");
        model.field_3663 = ImmutableList.of((Object)((Object)Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64)));
    }
}

