/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight.apparatus;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.config.ServerConfig;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.flight.apparatus.WingSettings;
import fuzs.fantasticwings.flight.apparatus.WingSettingsApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_7995;
import org.jetbrains.annotations.Nullable;

public enum FlightApparatusImpl implements WingSettingsApparatus,
class_3542
{
    ANGEL("angel_wings", () -> class_1802.field_8153, serverConfig -> serverConfig.angelWings),
    PARROT("parrot_wings", () -> class_1802.field_8264, serverConfig -> serverConfig.parrotWings),
    SLIME("slime_wings", () -> class_1802.field_8777, serverConfig -> serverConfig.slimeWings),
    BLUE_BUTTERFLY("blue_butterfly_wings", () -> class_1802.field_8345, serverConfig -> serverConfig.blueButterflyWings),
    MONARCH_BUTTERFLY("monarch_butterfly_wings", () -> class_1802.field_8492, serverConfig -> serverConfig.monarchButterflyWings),
    FIRE("fire_wings", () -> class_1802.field_8183, serverConfig -> serverConfig.fireWings),
    BAT("bat_wings", () -> class_1802.field_8745, serverConfig -> serverConfig.batWings),
    FAIRY("fairy_wings", () -> class_1802.field_17512, serverConfig -> serverConfig.fairyWings),
    EVIL("evil_wings", () -> class_1802.field_8606, serverConfig -> serverConfig.evilWings),
    DRAGON("dragon_wings", () -> class_1802.field_8814, serverConfig -> serverConfig.dragonWings),
    METALLIC("metallic_wings", () -> class_1802.field_8620, serverConfig -> serverConfig.metallicWings);

    private static final FlightApparatusImpl[] VALUES;
    private static final IntFunction<FlightApparatusImpl> BY_ID;
    private final String name;
    private final Supplier<class_1792> ingredient;
    private final Function<ServerConfig, WingSettings> settingsExtractor;
    @Nullable
    private class_6880<class_1842> potion;

    private FlightApparatusImpl(String name, Supplier<class_1792> ingredient, Function<ServerConfig, WingSettings> settingsExtractor) {
        this.name = name;
        this.ingredient = ingredient;
        this.settingsExtractor = settingsExtractor;
    }

    public static FlightApparatusImpl byId(int id) {
        return BY_ID.apply(id);
    }

    public FlightApparatus.FlightApparatusHolder holder() {
        return FlightApparatus.FlightApparatusHolder.of(this);
    }

    public String id() {
        return this.resourceLocation().toString();
    }

    public class_2960 resourceLocation() {
        return FantasticWings.id(this.name);
    }

    public class_2960 textureLocation() {
        return this.resourceLocation().method_48331("_bottle");
    }

    public class_2960 modelLocation() {
        return AbstractModelProvider.decorateItemModelLocation((class_2960)this.textureLocation());
    }

    public void registerPotion(RegistryManager registryManager) {
        this.potion = registryManager.registerPotion(this.name, () -> new class_1842(this.name, new class_1293[]{new class_1293(ModRegistry.GROW_WINGS_MOB_EFFECT, 1, this.ordinal())}));
    }

    public void onRegisterPotionBrewingMixes(RegisterPotionBrewingMixesCallback.Builder builder) {
        builder.registerPotionRecipe(class_1847.field_8974, this.ingredient.get(), this.getPotion());
        builder.registerPotionRecipe(class_1847.field_8964, this.ingredient.get(), this.getPotion());
    }

    public class_6880<class_1842> getPotion() {
        Objects.requireNonNull(this.potion, "potion is null");
        return this.potion;
    }

    public static void forEach(Consumer<FlightApparatusImpl> consumer) {
        for (FlightApparatusImpl flightApparatus : VALUES) {
            consumer.accept(flightApparatus);
        }
    }

    @Override
    public WingSettings getWingSettings() {
        return this.settingsExtractor.apply((ServerConfig)FantasticWings.CONFIG.get(ServerConfig.class));
    }

    public String method_15434() {
        return this.name;
    }

    static {
        VALUES = FlightApparatusImpl.values();
        BY_ID = class_7995.method_47914(Enum::ordinal, (Object[])VALUES, (class_7995.class_7996)class_7995.class_7996.field_41664);
    }
}

