/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.animator.AnimatorAvian;
import fuzs.fantasticwings.client.model.Model3DTexture;
import fuzs.fantasticwings.client.model.ModelWings;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class ModelWingsAvian
extends ModelWings<AnimatorAvian> {
    private final ModelPart root;
    private final ImmutableList<ModelPart> bonesLeft;
    private final ImmutableList<ModelPart> bonesRight;
    private final ImmutableList<ModelPart> feathersLeft;
    private final ImmutableList<ModelPart> feathersRight;

    public ModelWingsAvian(ModelPart modelPart) {
        this.root = modelPart;
        ModelPart leftCoracoid = modelPart.getChild("left_coracoid");
        ModelPart rightCoracoid = modelPart.getChild("right_coracoid");
        ModelPart leftHumerus = leftCoracoid.getChild("left_humerus");
        ModelPart rightHumerus = rightCoracoid.getChild("right_humerus");
        ModelPart leftUlna = leftHumerus.getChild("left_ulna");
        ModelPart rightUlna = rightHumerus.getChild("right_ulna");
        ModelPart leftCarpals = leftUlna.getChild("left_carpals");
        ModelPart rightCarpals = rightUlna.getChild("right_carpals");
        ModelPart leftCoracoidFeathers = leftCoracoid.getChild("left_coracoid_feathers");
        ModelWingsAvian.add3DTexture(leftCoracoidFeathers, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        ModelPart rightCoracoidFeathers = rightCoracoid.getChild("right_coracoid_feathers");
        ModelWingsAvian.add3DTexture(rightCoracoidFeathers, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        ModelPart leftTertiaryFeathers = leftHumerus.getChild("left_tertiary_feathers");
        ModelWingsAvian.add3DTexture(leftTertiaryFeathers, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        ModelPart rightTertiaryFeathers = rightHumerus.getChild("right_tertiary_feathers");
        ModelWingsAvian.add3DTexture(rightTertiaryFeathers, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        ModelPart leftSecondaryFeathers = leftUlna.getChild("left_secondary_feathers");
        ModelWingsAvian.add3DTexture(leftSecondaryFeathers, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        ModelPart rightSecondaryFeathers = rightUlna.getChild("right_secondary_feathers");
        ModelWingsAvian.add3DTexture(rightSecondaryFeathers, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        ModelPart leftPrimaryFeathers = leftCarpals.getChild("left_primary_feathers");
        ModelWingsAvian.add3DTexture(leftPrimaryFeathers, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        ModelPart rightPrimaryFeathers = rightCarpals.getChild("right_primary_feathers");
        ModelWingsAvian.add3DTexture(rightPrimaryFeathers, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)leftCoracoid, (Object)leftHumerus, (Object)leftUlna, (Object)leftCarpals);
        this.bonesRight = ImmutableList.of((Object)rightCoracoid, (Object)rightHumerus, (Object)rightUlna, (Object)rightCarpals);
        this.feathersLeft = ImmutableList.of((Object)leftCoracoidFeathers, (Object)leftTertiaryFeathers, (Object)leftSecondaryFeathers, (Object)leftPrimaryFeathers);
        this.feathersRight = ImmutableList.of((Object)rightCoracoidFeathers, (Object)rightTertiaryFeathers, (Object)rightSecondaryFeathers, (Object)rightPrimaryFeathers);
    }

    public static LayerDefinition createWingsLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        PartDefinition leftCoracoid = root.addOrReplaceChild("left_coracoid", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offset((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition rightCoracoid = root.addOrReplaceChild("right_coracoid", CubeListBuilder.create().texOffs(0, 34).addBox(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition leftHumerus = leftCoracoid.addOrReplaceChild("left_humerus", CubeListBuilder.create().texOffs(0, 0).addBox(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.offset((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition rightHumerus = rightCoracoid.addOrReplaceChild("right_humerus", CubeListBuilder.create().texOffs(0, 7).addBox(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.offset((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition leftUlna = leftHumerus.addOrReplaceChild("left_ulna", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.offset((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition rightUlna = rightHumerus.addOrReplaceChild("right_ulna", CubeListBuilder.create().texOffs(22, 6).addBox(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.offset((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition leftCarpals = leftUlna.addOrReplaceChild("left_carpals", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offset((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightCarpals = rightUlna.addOrReplaceChild("right_carpals", CubeListBuilder.create().texOffs(46, 4).addBox(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.offset((float)-8.5f, (float)0.0f, (float)0.0f));
        PartDefinition leftCoracoidFeathers = leftCoracoid.addOrReplaceChild("left_coracoid_feathers", CubeListBuilder.create(), PartPose.offset((float)0.4f, (float)0.0f, (float)1.0f));
        PartDefinition rightCoracoidFeathers = rightCoracoid.addOrReplaceChild("right_coracoid_feathers", CubeListBuilder.create(), PartPose.offset((float)-0.4f, (float)0.0f, (float)1.0f));
        PartDefinition leftTertiaryFeathers = leftHumerus.addOrReplaceChild("left_tertiary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition rightTertiaryFeathers = rightHumerus.addOrReplaceChild("right_tertiary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition leftSecondaryFeathers = leftUlna.addOrReplaceChild("left_secondary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightSecondaryFeathers = rightUlna.addOrReplaceChild("right_secondary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftPrimaryFeathers = leftCarpals.addOrReplaceChild("left_primary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightPrimaryFeathers = rightCarpals.addOrReplaceChild("right_primary_feathers", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void render(AnimatorAvian animator, float delta, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        ModelPart right;
        ModelPart left;
        int i;
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getWingRotation(i, delta));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getFeatherRotation(i, delta));
        }
        this.root.render(matrixStack, buffer, packedLight, packedOverlay, color);
    }

    private static void add3DTexture(ModelPart model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        Preconditions.checkState((boolean)model.cubes.isEmpty(), (Object)"model part cube list is not empty");
        model.cubes = ImmutableList.of((Object)((Object)Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64)));
    }
}

